UNIT Vcl8255;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : VCL8255.PAS
  BUT            : Composant VCL 8255 renfermant tout les contrles du PPI
  AUTEUR         : S.Claus / M.Amarantidis
  DATE           : Novembre 1996

  MODIFIE LE     : 05.12.1996  -  1.01  -  S.Claus
  RAISON         : - Ajout le type TPort
                   - Ajout les proprits ChenillardStop, ChenillardDelai et
                     ChenillardPort
                   - Ajout la mthode Chenillard

  MODIFIE LE     : 08.12.1996  -  1.02  -  S.Claus
  RAISON         : - Ajout l'tat mpIndefini pour le type TModePort
                   - Ajout le type TPortPattern
                   - Ajout les proprits PatternPorts, PatternStop,
                     PatternNbErreurs, PatternMessage et PatternNbOK
                   - Ajout la mthode Pattern
                   - Ajout l'vnement OnErrorPattern

  MODIFIE LE     : 08.12.1996  -  1.03  -  S.Claus
  RAISON         : - Correction de la procdure Chenillard: Un port en sortie,
                     deux ports en entre.
                   - Correction de la procdure Chenillard: Lors de la mise  1
                     du bit, il faut soustraire 1  NoBit car la procdure
                     SetBitB va de 0  7 et non pas de 1  8
                   - Ajout l'vnement OnChenillardBouge pour une utilisation
                     dans le programme.

  MODIFIE LE     : 14.12.1996  -  1.04  -  S.Claus
  RAISON         : - Quelques adaptations en vue de l'utilisation de ce
                     composant sous Delphi 2.0

  MODIFIE LE     : 22.12.1996  -  1.05  -  S.Claus
                   - Chang le type des proprits PatternNbErreurs et
                     PatternNbOK de WORD  LONGINT car sinon, on peut passer en
                     ngatif.
                   - Ajout la proprit Version afin de pouvoir lire la
                     version de la VCL depuis le programme appelant.

  MODIFIE LE     : 08.01.1997  -  1.06  -  M.Amarantidis
                   - Correction du chenillard pour n'allumer qu'une LED  la
                     fois et non pas n'importe quoi.

  MODIFIE LE     : 15.01.1997  -  1.07  -  S.Claus
                   - Ajout de nouveaux type de tests de pattern, en utilisant
                     uniquement deux ports: un en mission et un un rception.
                     Seul un des ports est configur en sortie. Ces nouveaux
                     paramtres sont: ppAB, ppAC, ppBA, ppBC, ppCA et ppCB
                   - Empche toute modification de l'tat des ports si le
                     chenillard ou le test de pattern est en cours d'excution
                   - N'excute pas une seconde fois le Chenillard ou le test de
                     pattern si une de ces deux procdures est dj en cours
                     d'excution.

  MODIFIE LE     : 22.01.1997  -  1.08  -  M.Amarantidis
                   - Modification pour la configuration des modes des ports:
                     rcrit chaque fois la configuration complte du port, car
                     la lecture du mot de contrle est INTERDITE.
                   - Empche l'excution du chenillard pendant le test de
                     pattern et empche l'excution du pattern pendant le
                     chenillard

  MODIFIE LE     : 22.01.1997  -  1.09  -  S.Claus
                   - Ajout de commentaires...
                   - Les variables internes au composant commencent toutes par
                     F...
                   - Utilise partout les fonctions d'E/S en assembleur au lieu
                     du tableau Port de Delphi
                   - N'arrte pas le Pattern si on excute le chenillard en
                     mme temps
                   - Ne reconfigure les port que si la nouvelle configuration
                     est diffrente de l'actuelle


  REMARQUES      : - Pour la configuration du 8255, la structure du mot de
                     contrle qu'il faut crire  l'adresse de contrle est la
                     suivante:

                     D7 D6 D5 D4 D3 D2 D1 D0
                                   
                       +--+                GROUPE B
                                    +----- Port C (bas):
                                           1: Entre / 0: Sortie
                                  +-------- Port B:
                                            1: Entre / 0: Sortie
                                +----------- Slection de mode:
                                             0: Mode 0 / 1: Mode 1
                              
                                             GROUPE A
                              +-------------- Port C (haut):
                                              1: Entre / 0: Sortie
                            +----------------- Port A:
                                               1: Entre / 0: Sortie
                       +----------------------- Slection de mode:
                                                00: Mode 0 / 01: Mode 1
                                                1X: Mode 2
                     
                     +-------------------------- Drapeau de mode dfini:
                                                 1: Actif

                   - Dans cette VCL, le 8255 n'est utilis que dans le mode 0,
                     qui est un mode d'entre/sortie simple.

                   - Les proprits PatternNbOK et PatternMessage sont en
                     lecture seule et ne peuvent tre vues avec l'inspecteur
                     d'objet.

 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  WinTypes, WinProcs, Classes, SysUtils;


CONST
  versionvcl            = '1.09';                            { Version du VCL }
  adressebase           = $300;                     { Adresse de base du 8255 }
  nbpas = 100;                            { Pattern pour le test de transfert }
  patterntest : ARRAY[1..nbpas] OF BYTE =
                       ($00, $01, $02, $03, $04, $05, $06, $07, $08, $09,
                        $10, $11, $12, $13, $14, $15, $16, $17, $18, $19,
                        $20, $21, $22, $23, $24, $25, $26, $27, $28, $29,
                        $30, $31, $32, $33, $34, $35, $36, $37, $38, $39,
                        $40, $41, $42, $43, $44, $45, $46, $47, $48, $49,
                        $50, $51, $52, $53, $54, $55, $56, $57, $58, $59,
                        $60, $61, $62, $63, $64, $65, $66, $67, $68, $69,
                        $70, $71, $72, $73, $74, $75, $76, $77, $78, $79,
                        $80, $81, $82, $83, $84, $85, $86, $87, $88, $89,
                        $90, $91, $92, $93, $94, $95, $96, $97, $98, $99);


TYPE
  TModePort = (mpSortie, mpEntree, mpIndefini);   { Etats possibles des ports }
  TPort = (pPortA, pPortB, pPortC);                                    { Port }

  TPortPattern = (ppABC, ppBAC, ppCAB,              { Type de test de pattern }
  {1.07  Nouvelles configurations possibles }
                  ppAB, ppAC, ppBA, ppBC, ppCA, ppCB);


  TPPI8255 = CLASS(TComponent)
    {=========================================================================}
    PRIVATE { Private-dclarations ---------------------------------- PRIVATE }

      {-- Divers }
      FVersion         : STRING;            { Version de la VCL }
      FAdresseBase8255 : WORD;              { Adresse de base du 8255 }
      FAdresseCtrl,                         { Adresse du port de contrle }
      FAdressePortA,                        { Adresse du port A }
      FAdressePortB,                        { Adresse du port B }
      FAdressePortC    : WORD;              { Adresse du port C }
      FCanWrite        : BOOLEAN;           { Accs au hardware autoris ? }

      {-- Configuration des ports }
      FModeDuPortA,                         { Mode de fonctionnement du port A }
      FModeDuPortB,                         { Mode de fonctionnement du port B }
      FModeDuPortC     : TModePort;         { Mode de fonctionnement du port C }

      {-- Chenillard }
      FPortChenillard  : TPort;             { Port utilis par le chenillard }
      FStopChenillard  : BOOLEAN;           { Arrt du chenillard }
      FDelaiChenillard : WORD;              { Dlai entre chaque chgmnt d'tat }
      FOnChenillardBouge : TNotifyEvent;    { Changemement d'tat }
      { Le type TNotifyEvent est le type des vnements qui n'ont pas de
      paramtre. Ces vnements se contentent de notifier au composant qu'un
      vnement particulier s'est produit. Par exemple, OnClick, qui est de
      type TNotifyEvent, indique au contrle qu'un clic s'est produit sur le
      contrle. }

      {-- Pattern }
      FPortsPattern    : TPortPattern;      { Ports utiliss par le pattern }
      FStopPattern     : BOOLEAN;           { Arrt du pattern }
      FNbErrPattern    : LONGINT;           { Nb pattern transmis AVEC erreur }
      FNbOkPattern     : LONGINT;           { Nb pattern transmis SANS erreur }
      FMsgErrPattern   : STRING;            { Description de l'erreur }
      FOnErrorPattern  : TNotifyEvent;      { Erreur de transm. survenue }

      {-- Divers }
      PROCEDURE AjusteAdresses;             { Set des adresses des ports }
      PROCEDURE SetAdresseBase(Adresse:WORD);   { Config de l'adresse de base }
      PROCEDURE SetCanWrite(WriteEnabled:BOOLEAN); { Change tat de FCanWrite }

      {-- Configuration des ports }
      PROCEDURE SetPortA(Mode:TModePort);    { Init du port A et FModeDuPortA }
      PROCEDURE SetPortB(Mode:TModePort);    { Init du port B et FModeDuPortB }
      PROCEDURE SetPortC(Mode:TModePort);    { Init du port C et FModeDuPortC }

      {-- Lecture / Ecriture }
      FUNCTION  LitPortA:BYTE;            { Lit valeur prsente sur le port A }
      PROCEDURE EcritPortA(Valeur:BYTE);  { Ecrit une valeur sur le port A }
      FUNCTION  LitPortB:BYTE;            { Lit valeur prsente sur le port B }
      PROCEDURE EcritPortB(Valeur:BYTE);  { Ecrit une valeur sur le port B }
      FUNCTION  LitPortC:BYTE;            { Lit valeur prsente sur le port C }
      PROCEDURE EcritPortC(Valeur:BYTE);  { Ecrit une valeur sur le port C }

      {-- Chenillard }
      PROCEDURE SetFPortChenillard(LePort:TPort);  { Slection du port }
      PROCEDURE SetFStopChenillard(Stop:BOOLEAN);  { Arrte le chenillard }
      PROCEDURE SetFDelaiChenillard(Delay:WORD);   { Modif de la "vitesse" }

      {-- Pattern }
      PROCEDURE SetFPortsPattern(Valeur:TPortPattern);  { Slection du port }
      PROCEDURE SetFStopPattern(Stop:BOOLEAN);          { Arrte le pattern }

    {=========================================================================}
    PUBLIC { Public-dclarations ------------------------------------- PUBLIC }
      CONSTRUCTOR Create(AOwner:TComponent); OVERRIDE;         { Constructeur }
      DESTRUCTOR Destroy; OVERRIDE;                             { Destructeur }

    {=========================================================================}
    PUBLISHED { Published declarations ---------------------------- PUBLISHED }

      { Le mot dclar property permet de dclarer une proprit.
      La dfinition d'une proprit dans une classe dclare un attribut nomm
      pour les objets de la classe et pour les actions associes  la lecture
      et  l'criture de l'attribut.

      READ    => Fonction / Variable utilis lors de la lecture de la proprit
      WRITE   => Fonction / Variable utilis lors de l'affectation d'une valeur
                  la proprit
      DEFAULT => Valeur par dfaut (optionnel)

      S'il n'y a pas de "section" WRITE, la proprit est en lecture seule... }


      { DIVERS ------------------------------------------------------- Divers }
      PROPERTY Version : STRING                        { Version du composant }
        READ FVersion;                     { Renvoie la valeur de la variable }

      PROPERTY Enabled : BOOLEAN                         { Composant activ ? }
        READ FCanWrite                     { Renvoie la valeur de la variable }
        WRITE SetCanWrite;                     { Modifie la vaiable FCanWrite }

      PROPERTY Adresse : WORD                    { Adresse de base du PPI8255 }
        READ FAdresseBase8255              { Renvoie la valeur de la variable }
        WRITE SetAdresseBase;


      { CONFIGURATION DES PORTS --------------------- Configuration des ports }
      PROPERTY ModePortA : TModePort                       { Config du port A }
        READ FModeDuPortA                  { Renvoie la valeur de la variable }
        WRITE SetPortA                    { Initialise le port et la variable }
        DEFAULT mpIndefini;                       { Par dfaut: tat indfini }

      PROPERTY ModePortB : TModePort                   { Comme pour le port A }
        READ FModeDuPortB
        WRITE SetPortB
        DEFAULT mpIndefini;

      PROPERTY ModePortC : TModePort                   { Comme pour le port A }
        READ FModeDuPortC
        WRITE SetPortC
        DEFAULT mpIndefini;


      { LECTURE / ECRITURE ------------------------------- Lecture / Ecriture }
      PROPERTY PortA : BYTE                                { Valeur du port A }
        READ LitPortA       { Lit la valeur actuellement prsente sur le port }
        WRITE EcritPortA;                      { Ecrit une valeur sur le port }

      PROPERTY PortB : BYTE                            { Comme pour le port A }
        READ LitPortB
        WRITE EcritPortB;

      PROPERTY PortC : BYTE                            { Comme pour le port A }
        READ LitPortC
        WRITE EcritPortC;


      { CHENILLARD ----------------------------------------------- Chenillard }
      PROPERTY ChenillardPort : TPort        { Port utilis par le chenillard }
        READ FPortChenillard                    { Lit quel est le port choisi }
        WRITE SetFPortChenillard                     { Initialise la variable }
        DEFAULT pPortA;                               { Par dfaut, le port A }

      PROPERTY ChenillardStop : BOOLEAN                 { Arrt du chenillard }
        READ FStopChenillard               { Renvoie la valeur de la variable }
        WRITE SetFStopChenillard                     { Initialise la variable }
        DEFAULT TRUE;                  { Par dfaut, le chenillard est arrt }

      PROPERTY ChenillardDelai : WORD { Attente entre chaque changemnt d'tat }
        READ FDelaiChenillard               { Lit la valeur actuelle du dlai }
        WRITE SetFDelaiChenillard                     { Modification du dlai }
        DEFAULT 300;                                   { Par dfaut, 300 [ms] }

      PROPERTY OnChenillardBouge:TNotifyEvent       { Le chenillard avance... }
        READ FOnChenillardBouge                 { Notification de l'vnement }
        WRITE FOnChenillardBouge;               { Notification de l'vnement }

      PROCEDURE Chenillard; VIRTUAL;                          { LE chenillard }


      { PATTERN ----------------------------------------------------- Pattern }
      PROPERTY PatternPorts : TPortPattern    { Ports utiliss par le pattern }
        READ FPortsPattern                  { Lit quel sont les ports choisis }
        WRITE SetFPortsPattern                       { Initialise la variable }
        DEFAULT ppABC;                 { Test du port A vers les ports B et C }

      PROPERTY PatternStop : BOOLEAN               { Arrt du test de pattern }
        READ FStopPattern                  { Renvoie la valeur de la variable }
        WRITE SetFStopPattern                        { Initialise la variable }
        DEFAULT TRUE;                     { Par dfaut, le pattern est arrt }

      PROPERTY PatternNbOK:LONGINT             { Nb de transferts sans erreur }
        READ FNbOkPattern                  { Renvoie la valeur de la variable }
        DEFAULT 0;                     { Par dfaut, pas encore de transferts }

      PROPERTY PatternNbErreurs:LONGINT        { Nb de transferts avec erreur }
        READ FNbErrPattern                 { Renvoie la valeur de la variable }
        DEFAULT 0;                                 { Par dfaut, pas d'erreur }

      PROPERTY PatternMessage:STRING      { Message descriptif erreur pattern }
        READ FMsgErrPattern;               { Renvoie la valeur de la variable }

      PROPERTY OnErrorPattern : TNotifyEvent       { Erreur de transmisson... }
        READ FOnErrorPattern                    { Notification de l'vnement }
        WRITE FOnErrorPattern;                  { Notification de l'vnement }

      PROCEDURE Pattern; VIRTUAL;                        { LE test de pattern }
  END; {CLASS TPPI8255}

PROCEDURE Register;    { Enregistrement de l'objet dans l'inspecteur d'objets }



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}


USES
  Forms,   { Pour "Application.ProcessMessages" }
  Dialogs;  


{1.04  Ajout le tableau de constantes Poids }
CONST
  Poids : ARRAY[0..7] OF WORD = (1, 2, 4, 8, 16, 32, 64, 128);


TYPE
  bbit = 0..7;                                        { Pour l'accs aux bits }



{-----------------------------------------------------------------------------}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{-----------------------------------------------------------------------------}



CONSTRUCTOR TPPI8255.Create;
{-----------------------------------------------------------------------------
  BUT ........... : C'est le CONSTRUCTOR. On initialise les variables du
                    composant et on appel le constructeur hrit de TComponent
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les variables globales sont initialises
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  {  Toujours appeler le constructeur reu en hritage }
  INHERITED Create(AOwner);
  FVersion := versionvcl;                                           { Version }
  FCanWrite        := FALSE;            { Interdiction d'crire sur les ports }
  SetAdresseBase(adressebase);               { Valeur par dfaut des adresses }
  FModeDuPortA     := mpIndefini;             { Etat des ports infdini (T'as }
  FModeDuPortB     := mpIndefini;                   { une boule de cristal ?) }
  FModeDuPortC     := mpIndefini;
  (*SetPortA(mpEntree);   Si FCanWrite est  FALSE, cette initialisation n'est
  SetPortB(mpEntree);     pas possible . . .
  SetPortC(mpEntree); *)
  FStopChenillard  := TRUE;                        { Le Chenillard est arrt }
  FDelaiChenillard := 300;          { 300ms d'attente entre chaque changement }
  FStopPattern     := TRUE;                   { Le test de pattern est arrt }
  FNbOkPattern     := 0;                                { Pas de transfert OK }
  FNbErrPattern    := 0;                                      { Pas d'erreurs }
  FMsgErrPattern   := '';                                    { Pas de message }
END; {CONSTRUCTOR Create}


DESTRUCTOR TPPI8255.Destroy;
{-----------------------------------------------------------------------------
  BUT ........... : Tout remettre en ordre quand on a fini
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  INHERITED Destroy;                  { Toujours appeler le destructor hrit }
END; {DESTRUCTOR Destroy}



{-----------------------------------------------------------------------------}
{ ACCES BAS NIVEAU ----------------------------------------- Accs bas niveau }
{-----------------------------------------------------------------------------}



FUNCTION InPortB(LePort:WORD):BYTE;
{-----------------------------------------------------------------------------
  BUT ........... : Lecture de l'tat d'un port
  ENTREE ........ : LePort = Port sur lequel la valeur doit tre lue
  SORTIE ........ : Valeur actuellement prsente sur le port
  EFFETS DE BORDS : --
  REMARQUE(S) ... : 1.04:  Sauvegarde puis restauration du registre DX par un
                           PUSH/POP
 -----------------------------------------------------------------------------}
VAR
  Valeur : BYTE;
BEGIN
  ASM
    PUSH DX
    MOV  DX, LePort
    IN   AL, DX
    MOV  Valeur, AL
    POP  DX
  END; {ASM}
  InPortB := Valeur;
END; {FUNCTION InPortB}


PROCEDURE OutPortB(LePort:WORD; Value:BYTE); {ASSEMBLER;}
{-----------------------------------------------------------------------------
  BUT ........... : Ecrit une valeur sur un port
  ENTREE ........ : LePort = Port sur lequel la valeur doit tre crite
                    Valuer = Valeur  crire sur le port
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : 1.04:  Sauvegarde puis restauration du registre DX par un
                           PUSH/POP
 -----------------------------------------------------------------------------}
BEGIN
  ASM
    PUSH  DX
    MOV   DX, LePort
    MOV   AL, Value
    OUT   DX, AL
    POP   DX
  END; {ASM}
END; {PROCEDURE OutPortB}


PROCEDURE SetBitB(VAR B : Byte; bit : bbit);
{-----------------------------------------------------------------------------
  BUT ........... : Mise  1 d'un bit
  ENTREE ........ : B = Le byte  modifier
                    bit = le no du bit  changer (entre 0 et 7)
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : 1.04  Ce test logique remplace la fonction en assembleur
                          suivante:
                    PROCEDURE SetBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
                    ASM
                      MOV CL, bit
                      MOV BL, 1
                      SHL BL, CL
                      LES DI, B
                      OR ES:[DI], BL  (*OR positionne le bit*)
                    END; (*PROCEDURE SetBitB*)
 -----------------------------------------------------------------------------}
BEGIN
  B := B OR Poids[bit]
END; {PROCEDURE SetBitB}


PROCEDURE ClearBitB(VAR B : Byte; bit : bbit);
{-----------------------------------------------------------------------------
  BUT ........... : Mise  0 d'un bit
  ENTREE ........ : B = Le byte  modifier
                    bit = le no du bit  changer (entre 0 et 7)
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : 1.04  Ce test logique remplace la fonction en assembleur
                          suivante:
                    PROCEDURE ClearBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
                    ASM
                      MOV CL, bit
                      MOV BL, 1
                      SHL BL, CL
                      NOT BL
                      LES DI, B
                      AND ES:[DI], BL (*AND of NOT BL met  zro le bit*)
                    END; (*PROCEDURE ClearBitB*)
 -----------------------------------------------------------------------------}
BEGIN
  B := B AND NOT Poids[bit];
END; {PROCEDURE ClearBitB}


(*1.04  Supprim cette procdure qui n'est pas utilise
PROCEDURE ToggleBitB(VAR B : Byte; bit : bbit); ASSEMBLER;
{-----------------------------------------------------------------------------
  BUT ........... : Inverse l'tat d'un bit (0->1 et 1->0)
  ENTREE ........ : B = Le byte  modifier
                    bit = le no du bit  changer (entre 0 et 7)
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... :
 -----------------------------------------------------------------------------}
ASM
  MOV CL, bit
  MOV BL, 1
  SHL BL, CL
  LES DI, B
  XOR ES:[DI], BL {XOR bascule le bit}
END; {PROCEDURE ToggleBitB} *)



{-----------------------------------------------------------------------------}
{ UTILITAIRES --------------------------------------------------- Utilitaires }
{-----------------------------------------------------------------------------}



FUNCTION Delay(DelayMS:LONGINT):BOOLEAN;
{-----------------------------------------------------------------------------
  BUT ........... : Remplace la fonction DELAY qui existrait sous DOS
  ENTREE ........ : DelayMS = Dlai d'attente en MS
                    bit = le no du bit  changer (entre 0 et 7)
  SORTIE ........ : TRUE s'il a t demand  l'application de quitter
  EFFETS DE BORDS : --
  REMARQUE(S) ... : 1.04  Remplac GetTick par GetTickCount + Simplification
                    (*FUNCTION Delay(DelayMS:LONGINT):BOOLEAN;
                    VAR
                      ET : LONGINT;
                    FUNCTION GetTick:LONGINT;
                    (* BUT: Indique depuis combien de temps Windows est en
                            fonction *)
                    VAR
                      TI:TTimerInfo;
                    BEGIN
                      (* Initialise la taille du RECORD TTimerInfo *)
                      TI.dwSize := SizeOf(TI);
                      TimerCount(@TI);
                      (* Retourne le temps coul *)
                      Result := TI.dwmsThisVM;
                    END; (*FUNCTION GetTick:LONGINT*)

                    BEGIN (*FUNCTION Delay*)
                      ET := GetTick;
                      REPEAT
                        Application.ProcessMessages;
                      UNTIL Application.Terminated OR (GetTick-ET > DelayMS);
                      Result := Application.Terminated;
                    END; (*FUNCTION Delay*)
 -----------------------------------------------------------------------------}
VAR
  ET : LONGINT;
BEGIN
  IF DelayMS = 0 THEN BEGIN           {1.09 Si pas d'attente, quitte de suite }
    Result := Application.Terminated;
    Exit;
  END; {IF}
  ET := GetTickCount;
  REPEAT
    Application.ProcessMessages;
  UNTIL Application.Terminated OR (GetTickCount-ET > DelayMS);
  Result := Application.Terminated;
END;{FUNCTION Delay}


PROCEDURE Register;
{-----------------------------------------------------------------------------
  BUT ........... : Ajoute ce composant dans la palette des composants de
                    Delphi
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Le composant est ajout  la page "More..."
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  RegisterComponents('More...', [TPPI8255]);
END; {PROCEDURE Register}



{-----------------------------------------------------------------------------}
{ ENTREE/SORTIE ----------------------------------------------- Entre/Sortie }
{-----------------------------------------------------------------------------}



PROCEDURE TPPI8255.SetCanWrite(WriteEnabled:BOOLEAN);
{-----------------------------------------------------------------------------
  BUT ........... : Autorise ou non l'criture sur les ports
  ENTREE ........ : WriteEnabled : L'tat futur de la variable FCanWrite
  SORTIE ........ : --
  EFFETS DE BORDS : FCanWrite prend la valeur du paramtre WriteEnabled
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  FCanWrite := WriteEnabled;
END; {PROCEDURE SetCanWrite}


PROCEDURE TPPI8255.AjusteAdresses;
{-----------------------------------------------------------------------------
  BUT ........... : Ajuste toutes les adresses du 8255 en fonction de l'adresse
                    de base
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les variables FAdressePortA, FAdressePortB, FAdressePortC
                    et FAdresseCtrl sont ajustes en fonction de la variable
                    FAdresseBase8255
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  FAdressePortA := FAdresseBase8255 + 0;
  FAdressePortB := FAdresseBase8255 + 1;
  FAdressePortC := FAdresseBase8255 + 2;
  FAdresseCtrl  := FAdresseBase8255 + 3;
END; {PROCEDURE TPPI8255.AjusteAdresses}


PROCEDURE TPPI8255.SetAdresseBase(Adresse:WORD);
{-----------------------------------------------------------------------------
  BUT ........... : Configuration de l'adresse de base
  ENTREE ........ : Adresse = L'adresse de base
  SORTIE ........ : --
  EFFETS DE BORDS : Les diffrentes adresses des ports du PPI sont modifies
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  FAdresseBase8255 := Adresse;
  AjusteAdresses;                                   { MAJ des autres adresses }
END; {PROCEDURE TPPI8255.SetAdresseBase}


PROCEDURE TPPI8255.SetPortA(Mode:TModePort);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation du port A en entre ou en sortie
  ENTREE ........ : Mode = Comment doit tre configur le port A
  SORTIE ........ : --
  EFFETS DE BORDS : La variable FModeDuPortA est initialise  la valeur de Mode
  REMARQUE(S) ... : - Cette modification n'est possible que si:
                      a) les E/S sont autorises, soit que FCanWrite est  TRUE
                      b) On ne configure pas le port dans un mode indfini (on
                         sait ce qu'on veut faire)
                      c) Le chenillard et le pattern ne sont pas en cours
                         d'excution
 -----------------------------------------------------------------------------}
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
   AND FStopChenillard AND FStopPattern THEN BEGIN
    {1.09 Ne reconfigure le port que si la configuration change }
    IF FModeDuPortA = Mode THEN Exit;
    FModeDuPortA := Mode;                               { MAJ de la proprit }
    {1.08  Cette lecture est interdite ! }
    (*ValeurControle := InPortB(FAdresseCtrl);  { Valeur de contrle actuelle }
    ValeurControle := Port[FAdresseCtrl];    { Valeur de contrle actuelle } *)
    ValeurControle := 0;
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4)   { A Sortie }
                               ELSE SetBitB  (ValeurControle, 4);  { A Entree }
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1)   { B Sortie }
                               ELSE SetBitB  (ValeurControle, 1);  { B Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 0);  { C Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 3);  { C Entree }
    OutPortB(FAdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortA}


PROCEDURE TPPI8255.SetPortB(Mode:TModePort);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation du port B en entre ou en sortie
  ENTREE ........ : Mode = Comment doit tre configur le port B
  SORTIE ........ : --
  EFFETS DE BORDS : La variable FModeDuPortB est initialise  la valeur de Mode
  REMARQUE(S) ... : - Cette modification n'est possible que si:
                      a) les E/S sont autorises, soit que FCanWrite est  TRUE
                      b) On ne configure pas le port dans un mode indfini (on
                         sait ce qu'on veut faire)
                      c) Le chenillard et le pattern ne sont pas en cours
                         d'excution
 -----------------------------------------------------------------------------}
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
     AND FStopChenillard AND FStopPattern THEN BEGIN
    {1.09 Ne reconfigure le port que si la configuration change }
    IF FModeDuPortB = Mode THEN Exit;
    FModeDuPortB := Mode;                               { MAJ de la proprit }
    {1.08  Cette lecture est interdite ! }
    (*ValeurControle := InPortB(FAdresseCtrl);  { Valeur de contrle actuelle }
    ValeurControle := Port[FAdresseCtrl];    { Valeur de contrle actuelle } *)
    ValeurControle := 0;
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4)   { A Sortie }
                               ELSE SetBitB  (ValeurControle, 4);  { A Entree }
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1)   { B Sortie }
                               ELSE SetBitB  (ValeurControle, 1);  { B Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 0);  { C Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 3);  { C Entree }
    OutPortB(FAdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortB}


PROCEDURE TPPI8255.SetPortC(Mode:TModePort);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation du port C en entre ou en sortie
  ENTREE ........ : Mode = Comment doit tre configur le port C
  SORTIE ........ : --
  EFFETS DE BORDS : La variable FModeDuPortC est initialise  la valeur de Mode
  REMARQUE(S) ... : - Cette modification n'est possible que si:
                      a) les E/S sont autorises, soit que FCanWrite est  TRUE
                      b) On ne configure pas le port dans un mode indfini (on
                         sait ce qu'on veut faire)
                      c) Le chenillard et le pattern ne sont pas en cours
                         d'excution
                    - L'initialisation de se port se fait en deux fois, car il
                      ne s'agit pas d'un port 8 bits, mais de deux ports de 4
                      bits
 -----------------------------------------------------------------------------}
VAR
  ValeurControle : BYTE;
BEGIN
  {1.07  Empche toute modification de l'tat du port si le chenillard ou
         le pattern est en cours d'excution
  IF FCanWrite AND (Mode <> mpIndefini) THEN BEGIN }
  IF FCanWrite AND (Mode <> mpIndefini)
     AND FStopChenillard AND FStopPattern THEN BEGIN
    {1.09 Ne reconfigure le port que si la configuration change }
    IF FModeDuPortC = Mode THEN Exit;
    FModeDuPortC := Mode;                               { MAJ de la proprit }
    {1.08  Cette lecture est interdite ! }
    (*ValeurControle := InPortB(FAdresseCtrl);  { Valeur de contrle actuelle }
    ValeurControle := Port[FAdresseCtrl];    { Valeur de contrle actuelle } *)
    ValeurControle := 0;
    SetBitB(ValeurControle, 7);               { Drapeau de mode dfini: Actif }
    ClearBitB(ValeurControle, 6);     { Passe en mode 0 pour tous les groupes }
    ClearBitB(ValeurControle, 5);
    ClearBitB(ValeurControle, 2);
    {1.08  Reconfigure chaque fois tous les ports}
    IF FModeDuPortA = mpSortie THEN ClearBitB(ValeurControle, 4)   { A Sortie }
                               ELSE SetBitB  (ValeurControle, 4);  { A Entree }
    IF FModeDuPortB = mpSortie THEN ClearBitB(ValeurControle, 1)   { B Sortie }
                               ELSE SetBitB  (ValeurControle, 1);  { B Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 0)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 0);  { C Entree }
    IF FModeDuPortC = mpSortie THEN ClearBitB(ValeurControle, 3)   { C Sortie }
                               ELSE SetBitB  (ValeurControle, 3);  { C Entree }
    OutPortB(FAdresseCtrl, ValeurControle);   { Configure correctement le 8255 }
  END; {IF}
END; {PROCEDURE SetPortC}


FUNCTION TPPI8255.LitPortA:BYTE;
{-----------------------------------------------------------------------------
  BUT ........... : Lit la valeur actuellement prsente sur le port A
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Result := InPortB(FAdressePortA)
END; {FUNCTION LitPortA}


PROCEDURE TPPI8255.EcritPortA(Valeur:BYTE);
{-----------------------------------------------------------------------------
  BUT ........... : Ecrit une valeur sur le port A
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - L'criture n'est possible que si
                      a) le port est configur en sortie
                      b) les E/S sont permises
 -----------------------------------------------------------------------------}
BEGIN
  IF FCanWrite AND (FModeDuPortA = mpSortie) THEN BEGIN
    OutPortB(FAdressePortA, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortA}


FUNCTION TPPI8255.LitPortB:BYTE;
{-----------------------------------------------------------------------------
  BUT ........... : Lit la valeur actuellement prsente sur le port B
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Result := InPortB(FAdressePortB)
END; {FUNCTION LitPortB}


PROCEDURE TPPI8255.EcritPortB(Valeur:BYTE);
{-----------------------------------------------------------------------------
  BUT ........... : Ecrit une valeur sur le port B
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - L'criture n'est possible que si
                      a) le port est configur en sortie
                      b) les E/S sont permises
 -----------------------------------------------------------------------------}
BEGIN
  IF FCanWrite AND (FModeDuPortB = mpSortie) THEN BEGIN
    OutPortB(FAdressePortB, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortB}


FUNCTION TPPI8255.LitPortC:BYTE;
{-----------------------------------------------------------------------------
  BUT ........... : Lit la valeur actuellement prsente sur le port C
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Result := InPortB(FAdressePortC)
END; {FUNCTION LitPortC}


PROCEDURE TPPI8255.EcritPortC(Valeur:BYTE);
{-----------------------------------------------------------------------------
  BUT ........... : Ecrit une valeur sur le port C
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - L'criture n'est possible que si
                      a) le port est configur en sortie
                      b) les E/S sont permises
 -----------------------------------------------------------------------------}
BEGIN
  IF FCanWrite AND (FModeDuPortC = mpSortie) THEN BEGIN
    OutPortB(FAdressePortC, Valeur);
  END; {IF}
END; {PROCEDURE EcritPortC}



{-----------------------------------------------------------------------------}
{ CHENILLARD ----------------------------------------------------- Chenillard }
{-----------------------------------------------------------------------------}



PROCEDURE TPPI8255.SetFStopChenillard(Stop:BOOLEAN);
{-----------------------------------------------------------------------------
  BUT ........... : Arrte le Chenillard en mettant  TRUE la variable
                    FStopChenillard
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  FStopChenillard := Stop;
END; {PROCEDURE SetFStopChenillard}


PROCEDURE TPPI8255.SetFPortChenillard(LePort:TPort);
{-----------------------------------------------------------------------------
  BUT ........... : Change le port utilis par le chenillard
  ENTREE ........ : LePort = Le port choisi pour le chenillard
  SORTIE ........ : --
  EFFETS DE BORDS : FPortChenillard est initialis  la valeur de LePort
  REMARQUE(S) ... : - Si le chenillard est en fonction, il sera arrt
 -----------------------------------------------------------------------------}
BEGIN
   SetFStopChenillard(TRUE);  { Arrte le chenillard s'il tait en train de..
                                                                    ..tourner }
   FPortChenillard := LePort; { Hissez les voiles, et virer  babord, on..
                                                             ..change de port }
END; {PROCEDURE SetFPortChenillard}


PROCEDURE TPPI8255.SetFDelaiChenillard(Delay:WORD);
{-----------------------------------------------------------------------------
  BUT ........... : Fixe la vitesse du Chenillard, cd le temps qu'il faut
                    attendre entre chaque changement d'tat
  ENTREE ........ : Delay = Le nombre de [ms] qu'il faut attendre. Cette valeur
                            va de 0  65535 (1000 = 1 seconde)
  SORTIE ........ : --
  EFFETS DE BORDS : FDelaiChenillard est initialis  la valeur de Delay
  REMARQUE(S) ... : - Si le chenillard est en fonction, il sera arrt
 -----------------------------------------------------------------------------}
BEGIN
  FDelaiChenillard := Delay;
END; {PROCEDURE SetFDelaiChenillard}


PROCEDURE TPPI8255.Chenillard;
{-----------------------------------------------------------------------------
  BUT ........... : Effet de Chenillard sur un des ports
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - Pour arrter le chenillard une fois qu'il est lanc, il
                      faut mettre  TRUE la variable FStopChenillard via la
                      proprit ChenillardStop
                    - A chaque changement d'tat du chenillard, l'vnement
                      OnChenillardBouge est dclench
 -----------------------------------------------------------------------------}
VAR
  EtatPort : BYTE;                                      { Etat actuel du port }
  Sens     : SHORTINT;                       { Sens de dplacement du bit  1 }
  NoBit    : SHORTINT;                                { No du bit qui est  1 }
BEGIN
  {-- Initialisations }
  EtatPort := 0;
  Sens     := +1;
  NoBit    := 0;

  {-- Si le test de pattern est en cours, l'arrte et quitte cette procdure }
  IF NOT FStopPattern THEN BEGIN
    { 1.09 Il n'est pas ncessaire de l'arrter }
    {SetFStopPattern(TRUE);}
    {1.07  Quitte la procdure }
    Exit;
  END {IF}
  ELSE IF NOT FStopChenillard THEN BEGIN
    {1.07  Si le chenillard est dj activ quitte la procdure }
    Exit;
  END; {IF}

  {-- Set du mode de fonctionnement des diffrents ports en fonction du port
      choisi pour le chenillard }
  CASE FPortChenillard OF
    pPortA : BEGIN
               SetPortA(mpSortie);  SetPortB(mpEntree);  SetPortC(mpEntree);
               EcritPortA(EtatPort);
             END; {BRANCH OF CASE}
    pPortB : BEGIN
               SetPortA(mpEntree);  SetPortB(mpSortie);  SetPortC(mpEntree);
               EcritPortB(EtatPort);
             END; {BRANCH OF CASE}
    pPortC : BEGIN
               SetPortA(mpEntree);  SetPortB(mpEntree);  SetPortC(mpSortie);
               EcritPortC(EtatPort);
             END; {BRANCH OF CASE}
  END; {CASE OF}

  {-- C'est parti !! pour le chenillard style K2000 }
  FStopChenillard := FALSE;
  REPEAT
    IF Sens > 0 THEN BEGIN                    { Dplacement de la LED allume }
      NoBit := NoBit + 1;
      IF NoBit > 8 THEN BEGIN                                 { Dbordement ? }
        Sens := -1;                           { Oui, alors changement de sens }
        NoBit := NoBit - 2;
      END; {IF}
    END {IF}
    ELSE BEGIN
      NoBit := NoBit - 1;
      IF NoBit < 1 THEN BEGIN                                 { Dbordement ? }
        Sens := +1;                           { Oui, alors changement de sens }
        NoBit := NoBit + 2;
      END; {IF}
    END; {ELSE}
    {1.06  Remplace le ClearBitB par un := 0, car sinon, on affiche
     n'importe quoi ! }
    {ClearBitB(EtatPort, NoBit);                                  { RAZ du bit }
    EtatPort := 0;
    {1.03  NoBit-1, pas NoBit, car SetBitB va de 0  7 et non pas de 1  8 }
    SetBitB(EtatPort, NoBit-1);                            { Mise  un du bit }
    CASE FPortChenillard OF                              { Sortie sur le port }
      pPortA : EcritPortA(EtatPort);
      pPortB : EcritPortB(EtatPort);
      pPortC : EcritPortC(EtatPort);
    END; {CASE OF}

    IF Assigned(FOnChenillardBouge) THEN BEGIN
      FOnChenillardBouge(Self);     { Signale que a a boug en dclenchant..
                                              ..l'evnement OnChenillardBouge }
    END; {IF}

    IF Delay(FDelaiChenillard) THEN BEGIN            { On attend un moment... }
      {Il a t demand de quitter l'application, alors on arrte ! }
      FStopChenillard := TRUE;
    END; {IF}
    { -- Laisse Windows faire son boulot.
         Cette ligne est OBLIGATOIRE, sinon on Windows ne pourra jamais prendre
         excuter le code d'un contrle qui met la variable FStopChenillard 
         TRUE, donc arrte le chenillard... }
    Application.ProcessMessages;
  UNTIL FStopChenillard;                                        { On arrte ? }

  CASE FPortChenillard OF                         { Met la valeur du port  0 }
    pPortA : EcritPortA(0);
    pPortB : EcritPortB(0);
    pPortC : EcritPortC(0);
  END; {CASE OF}

  IF Assigned(FOnChenillardBouge) THEN BEGIN
    FOnChenillardBouge(Self);                        { Signale que a a boug }
  END; {IF}

END; {PROCEDURE Chenillard}



{-----------------------------------------------------------------------------}
{ PATTERN ----------------------------------------------------------- Pattern }
{-----------------------------------------------------------------------------}



PROCEDURE TPPI8255.SetFPortsPattern(Valeur:TPortPattern);
{-----------------------------------------------------------------------------
  BUT ........... : Choix des ports  utiliser pour le test de pattern
  ENTREE ........ : Valeur = les diffrents ports  utiliser pour le test
  SORTIE ........ : --
  EFFETS DE BORDS : FPortsPattern est initialis  Valeur
  REMARQUE(S) ... : Si le test est dj en cours de fonctionnement, l'arrte
 -----------------------------------------------------------------------------}
BEGIN
  {1.09 C'est pas le chenillard qu'il faut arrter, mais le pattern ! }
  (*{ Arrte le chenillard s'il tait en train de tourner }
  SetFStopChenillard(TRUE); *)
  SetFStopPattern(TRUE);
  { Choix des ports  utiliser pour le test de pattern }
  FPortsPattern := Valeur;
END; {PROCEDURE SetFPortsPattern}


PROCEDURE TPPI8255.SetFStopPattern(Stop:BOOLEAN);
{-----------------------------------------------------------------------------
  BUT ........... : Arrte (peut-tre) le test de transmission de Pattern
  ENTREE ........ : Stop = TRUE si on veut arrter le test, sinon FALSE
  SORTIE ........ : --
  EFFETS DE BORDS : - FStopPattern est initialis  la valeur de Stop
                    - Le test n'est arrt que si FStopPattern vaut TRUE
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  FStopPattern := Stop;
END; {PROCEDURE SetFStopPattern}


PROCEDURE TPPI8255.Pattern;
{-----------------------------------------------------------------------------
  BUT ........... : Test de transfert de donnes entre deux ports
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - Pour arrter le test une fois qu'il est lanc, il
                      faut mettre  TRUE la variable FStopPattern via la
                      proprit PatternStop
                    - A chaque changement d'tat du chenillard, l'vnement
                      OnChenillardBouge est dclench
 -----------------------------------------------------------------------------}
VAR
  NoPattern     : INTEGER;                      { No du pattern  transmettre }
  LuA, LuB, LuC : BYTE;                              { Valeur rellement lues }
  MessageErr    : STRING;    { Message d'erreur en cas de transmission loupe }
BEGIN

  { On ne commence pas si le chenillard ou le test de pattern sont dj en
    cours d'excution }
  IF NOT FStopChenillard THEN BEGIN
    {1.09 Il n'y a pas besoin de l'arrter ! on ne commence pas quelque chose
          de nouveau, c'est tout }
    {SetFStopChenillard(TRUE);}
    {1.07  Quitte la procdure si le chenillard est en cours de fonctionnement }
    Exit;
  END {IF}
  ELSE IF NOT FStopPattern THEN BEGIN
    {1.07  Quitte la procdure si le test de pattern est dj activ }
    Exit;
  END; {IF}

  { Set des ports en fonction du port choisi pour le pattern }
  {1.07  Nouvelles configurations possibles, en utilisant que 2 ports au lieu
         de trois }
  CASE FPortsPattern OF
    ppAB,
    ppAC,
    ppABC : BEGIN                             { A => B, A => C ou A => B et C }
              SetPortA(mpSortie); SetPortB(mpEntree); SetPortC(mpEntree);
            END; {BRANCH OF CASE}
    ppBA,
    ppBC,
    ppBAC : BEGIN                             { B => A, B => C ou B => A et C }
              SetPortA(mpEntree); SetPortB(mpSortie); SetPortC(mpEntree);
            END; {BRANCH OF CASE}
    ppCA,
    ppCB,
    ppCAB : BEGIN                             { C => A, C => B ou C => A et B }
              SetPortA(mpEntree); SetPortB(mpEntree); SetPortC(mpSortie);
             END; {BRANCH OF CASE}
  END; {CASE OF}

  FNbErrPattern    := 0;                                { Pas encore d'erreur }
  FNbOkPattern     := 0;
  FMsgErrPattern:= '';
  NoPattern        := 1;                   { Commence avec le premier pattern }
  LuA := 0; LuB := 0; LuC := 0;                   { Rien vu, rien bu, rien lu }

  { C'est parti !! }
  FStopPattern := FALSE;
  REPEAT
    CASE FPortsPattern OF
      ppABC : BEGIN { -------------------------------------------- A => B & C }
                { Ecrit une valeur }
                EcritPortA(patterntest[NoPattern]);
                { Lit ce qu'il y a sur les autres ports }
                LuB := LitPortB;
                LuC := LitPortC;
                IF ((patternTest[NoPattern] <> LuB) OR              { Compare }
                    (patternTest[NoPattern] <> LuC)) THEN BEGIN
                  { IL Y A UN BOGUE !! }
                  Inc(FNbErrPattern);               { MAJ du nombre d'erreurs }
                  { Cration du message d'erreur }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  MessageErr := MessageErr+' & C('+IntToHex(LuC, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  Inc(FNbOkPattern);                          {  Transfert OK }
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBAC : BEGIN                                      { Pattern B => A & C }
                EcritPortB(patterntest[NoPattern]);
                LuA := LitPortA;
                LuC := LitPortC;
                IF ((patternTest[NoPattern] <> LuA) OR
                    (patternTest[NoPattern] <> LuC)) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  MessageErr := MessageErr+' & C('+IntToHex(LuC, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCAB : BEGIN                                      { Pattern C => A & B }
                EcritPortC(patterntest[NoPattern]);
                LuA := LitPortA;
                LuB := LitPortB;
                IF ((patternTest[NoPattern] <> LuA) OR
                    (patternTest[NoPattern] <> LuB)) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  MessageErr := MessageErr+' & B('+IntToHex(LuB, 2) + 'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      {1.07  Nouvelles configurations possibles }
      ppAB  : BEGIN                                          { Pattern A => B }
                EcritPortA(patterntest[NoPattern]);
                LuB := LitPortB;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppAC  : BEGIN                                          { Pattern A => C }
                EcritPortA(patterntest[NoPattern]);
                LuC := LitPortC;
                IF (patternTest[NoPattern] <> LuC) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' A('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> C('+IntToHex(LuC,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBA  : BEGIN                                          { Pattern B => A }
                EcritPortB(patterntest[NoPattern]);
                LuA := LitPortA;
                IF (patternTest[NoPattern] <> LuA) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuA,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppBC  : BEGIN                                          { Pattern B => C }
                EcritPortB(patterntest[NoPattern]);
                LuC := LitPortC;
                IF (patternTest[NoPattern] <> LuC) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' B('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> C('+IntToHex(LuC,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCA  : BEGIN                                          { Pattern C => A }
                EcritPortC(patterntest[NoPattern]);
                LuA := LitPortA;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> A('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
      ppCB  : BEGIN                                          { Pattern C => B }
                EcritPortC(patterntest[NoPattern]);
                LuB := LitPortB;
                IF (patternTest[NoPattern] <> LuB) THEN BEGIN
                  {-- Erreur lors du transfert }
                  Inc(FNbErrPattern);                { Une erreur de plus ... }
                  MessageErr := ' C('+IntToHex(patterntest[NoPattern],2)+'h)';
                  MessageErr := MessageErr+' -> B('+IntToHex(LuB,2)+'h)';
                  FMsgErrPattern := MessageErr;
                  IF Assigned(FOnErrorPattern) THEN BEGIN
                    FOnErrorPattern(Self);         { Notification de l'erreur }
                  END; {IF}
                END {IF}
                ELSE BEGIN
                  {-- Transfert OK }
                  Inc(FNbOkPattern);
                END; {ELSE}
              END; {BRANCH OF CASE}
    END; {CASE OF}
    {-- Passe au pattern suivant }
    Inc(NoPattern);
    IF NoPattern > nbpas THEN BEGIN
      { Tout a t transmis, on recommence au dpart }
      NoPattern := 1;
    END; {IF}
    { -- Laisse Windows faire son boulot.
         Cette ligne est OBLIGATOIRE, sinon on Windows ne pourra jamais prendre
         excuter le code d'un contrle qui met la variable FStopChenillard 
         TRUE, donc arrte le chenillard... }
    Application.ProcessMessages;
    IF Application.Terminated THEN BEGIN
      { Il a t demand d'arrter l'application, alors on fait ce qui a t
        demand, on arrte.}
      FStopPattern := TRUE;
    END; {IF}
  UNTIL FStopPattern;

END; {PROCEDURE Pattern}



{-----------------------------------------------------------------------------}
{ THAT'S ALL -------------------------------------------------------- The end }
{-----------------------------------------------------------------------------}



INITIALIZATION
END. {UNIT Vcl8255}
