UNIT Uquartz;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UQUARTZ.PAS
  BUT            : Slection du la frquence du quartz utilis sur la carte
  AUTEUR         : Michael Amarantidis / Stphane Claus
  DATE           : Mars 1997

  MODIFIE LE     :
  RAISON         :

  REMARQUES      : - Cette frquence est sauvegarde dans le fichier INI
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, UAlnEdit;


TYPE
  TfrmQuartz = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    grpbxFrequence: TGroupBox;
    lblHertz: TLabel;
    aedtFrequence: TAlignEdit;
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE aedtFrequenceChange(Sender: TObject);
    PROCEDURE bitbtnOKClick(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmQuartz: TfrmQuartz;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  UPrincpl;


PROCEDURE TfrmQuartz.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation de la fiche en fonction des paramtres
                    actuels du programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Caption := Application.Title;                         { Titre de la fentre }
  aedtFrequence.ShowHint := affichehint;                 { Affichage des Hint }
  { Lit la frquence actuellement utilise }
  aedtFrequence.Text := FloatToStr(frmMain.PIT8254.Quartz);
END; {PROCEDURE FormActivate}


PROCEDURE TfrmQuartz.aedtFrequenceChange(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Test si la frquence saisie par l'utilisateur est correcte.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Si la frquence est incorrecte, la zone de saisie devient
                    toute rouge
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
VAR
  Frequence  : EXTENDED;
BEGIN
  TRY
    {-- Lit la frquence saisie + conversion en un EXTENDED }
    Frequence := StrToFloat(aedtFrequence.Text);
    {-- Valeur utilisable ? (enfin, qui ne va pas causer d'erreur lors des
        divisions futures...) }
    IF Frequence >= 1 THEN aedtFrequence.Color := clWindow;
  EXCEPT
    aedtFrequence.Color := clRed;        { Valeur incorrecte: On voit rouge ! }
  END; {TRY}
END; {PROCEDURE aedtFrequenceChange}


PROCEDURE TfrmQuartz.bitbtnOKClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Sauvegarde de la frquence lors de la fermeture de la
                    fiche (enfin, seulement si on a cliqu sur le bouton OK,
                    mais pas si on a utilis le menu systme)
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
VAR
  Frequence  : EXTENDED;
BEGIN
  TRY
    Frequence := StrToFloat(aedtFrequence.Text);    { Lit la frquence saisie }
    IF Frequence < 1 THEN Frequence := 1;        { Au minimun 1 [Hz] please ! }
    frmMain.PIT8254.Quartz := Frequence;
  EXCEPT
    { Valeur incorrecte, alors on ne la garde pas }
  END; {TRY}
END; {PROCEDURE bitbtnOKClick}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Uquartz}
