UNIT Uprincpl;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UPRINCIPL.PAS
  BUT            : Unit principale du projet.
  AUTEUR         : Michael Amarantidis & Stphane Claus
  DATE           : Dcembre 1996 / Janvier 1997

  MODIFIE LE     : 12.04.1997  -  2.02  -  S.Claus
  RAISON(S)      : - Ajout d'un menu pour le 8254
                   - Correction du composant PPI8255
                   - Ajout de commentaires

  REMARQUES      : - Ce programme utilise le fichier d'aide ETIPCBUS.HLP.
                     Pour en connaitre la liste complte: double clic sur
                     l'cone de l'application dans la bote de dialogue
                     "A propos de...".

                   - Pratiquement toutes les procdures et fonctions ont un
                     paramtre "Sender: TObject".
                     Il n'est jamais dcrit dans les enttes des procdures.
                     Ce paramtre Sender, dans un gestionnaire d'vnement,
                     communique  Delphi le composant qui a reu l'vnement
                     et par consquent fait appel au gestionnaire.
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  { Units "Maison" ajoute par moi et ralise par myself }
  Vcl8255,           { Composant PPI 8255}
  Vcl8254,           { Composant PIT 8254}
  UAPropos,          { Bote de dialogue "A propos de..." }
  UCfgPrgm,          { Configuration du programme }
  UCfgPrts,          { Configuration des ports du PPI 8255 }
  UCfgBs55,          { Choix de l'adresse de base }
  ULit,              { Lecture de l'tat d'un des ports du PPI 8255 }
  UEcrit,            { Ecriture sur l'un des ports du PPI 8255 }
  UChen,             { Effet de chenillard sur un des ports du PPI 8255 }
  UPattern,          { Transmission de donnes entre 2 ou 3 ports du PPI 8255 }
  Uchrono,           { Chronogramme du PPI 8255 (Ne fonctionne pas) }
  UQuartz,           { Frquence du quartz pour le PIT 8254 }
  UGenerat,          { Gnrateur de frquence }
  UFreq,
  { Units Delphi ajoutes automatiquement par Delphi himself... }
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ExtCtrls, StdCtrls, IniFiles,
  Buttons, Wordcap, Prevchek;


CONST
  version = 'Version 2.03';                           { Version du programme }
  copyright = ' 1996, 1997 by S.Claus & M.Amarantidis';      { Commentaire ? }
  fichierini = 'ETIPCBUS.INI';                           { Nom du fichier INI }

  debugmode : BOOLEAN = TRUE;                      { Activation du mode debug }
  debugcolor : TColor = clRed;               { Couleur fentres en mode debug }
  debugetatports : BOOLEAN = FALSE;                { Affiche l'tat des ports }
  debugdelaietatports : INTEGER = 1000;         { Vitesse de rafrachissement }
  affichehint : BOOLEAN = TRUE;                          { Affichage des Hint }
  base8255 : WORD = $300;                        { Adresse de base du PPI8255 }
  offset8254 : BYTE = 8;           { Diffrence entre les 2 addresses de base }
  en8255_8254 : BOOLEAN = TRUE;                         { 8255 & 8254 Enabled }
  freqquartz : EXTENDED = 6000000;                      { Frquence du Quartz }


TYPE
  TfrmMain = CLASS(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    mQuitter: TMenuItem;
    N1: TMenuItem;
    mConfigurationProgramme: TMenuItem;
    pnlStatuts: TPanel;
    pnlDebug: TPanel;
    lblEtatPorts: TLabel;
    grpbx8255: TGroupBox;
    lblPortA: TLabel;
    lblPortC: TLabel;
    lblPortB: TLabel;
    lblModePortA: TLabel;
    lblModePortB: TLabel;
    lblModePortC: TLabel;
    timerEtatPorts: TTimer;
    lblBase55: TLabel;
    m8255: TMenuItem;
    mChenillard: TMenuItem;
    mPattern: TMenuItem;
    mLecture: TMenuItem;
    mEcriture: TMenuItem;
    N2: TMenuItem;
    mConfiguration8255: TMenuItem;
    mAdresseBase8255: TMenuItem;
    mEtatPorts8255: TMenuItem;
    Aide1: TMenuItem;
    Apropos1: TMenuItem;
    mHelpIndex: TMenuItem;
    N3: TMenuItem;
    mChronogramme: TMenuItem;
    MSOfficeCaption1: TMSOfficeCaption;
    m8254: TMenuItem;
    mGenerateur: TMenuItem;
    mFrequencemetre: TMenuItem;
    mConfiguration8254: TMenuItem;
    mAdresseDeBaseBis: TMenuItem;
    N4: TMenuItem;
    PIT8254: TPIT8254;
    grpbx8254: TGroupBox;
    lblBase54: TLabel;
    lblModeCnt0: TLabel;
    lblModeCnt1: TLabel;
    lblModeCnt2: TLabel;
    lblCompteur0: TLabel;
    lblCompteur1: TLabel;
    lblCompteur2: TLabel;
    mFrquenceQuartz: TMenuItem;
    lblQuartz: TLabel;
    N5: TMenuItem;
    PPI8255: TPPI8255;
    OneInstance: TOneInstance;
    PROCEDURE mQuitterClick(Sender: TObject);
    PROCEDURE mConfigurationProgrammeClick(Sender: TObject);
    PROCEDURE timerEtatPortsTimer(Sender: TObject);
    PROCEDURE mHelpIndexClick(Sender: TObject);
    PROCEDURE mEtatPorts8255Click(Sender: TObject);
    PROCEDURE mAdresseBaseClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE AProposClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; VAR Action: TCloseAction);
    PROCEDURE mLectureClick(Sender: TObject);
    PROCEDURE mEcritureClick(Sender: TObject);
    PROCEDURE mChenillardClick(Sender: TObject);
    PROCEDURE PPI8255ChenillardBouge(Sender: TObject);
    PROCEDURE mPatternClick(Sender: TObject);
    PROCEDURE PPI8255ErrorPattern(Sender: TObject);
    PROCEDURE mChronogrammeClick(Sender: TObject);
    PROCEDURE mGenerateurClick(Sender: TObject);
    PROCEDURE mFrquenceQuartzClick(Sender: TObject);
    procedure mFrequencemetreClick(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
    PROCEDURE DisplayHint(Sender: TObject);
    PROCEDURE LireFichierINI(Sender: TObject);
    PROCEDURE EcrireFichierINI(Sender: TObject);
  END; {CLASS}


VAR
  frmMain: TfrmMain;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


VAR
  FreqStr  : STRING;               { Stokage de la frquence du Quartz pour la
                                     sauvegarde dans le fichier INI. }



{=============================================================================}
{ DIVERS ------------------------------------------------------------- Divers }
{=============================================================================}



PROCEDURE TfrmMain.LireFichierINI(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialise les constantes en lisant le contenu du fichier
                    INI
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les constantes sont initialises
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
VAR
  FicINI: TIniFile;     { Objet permetant d'crire ou de lire un fichier .INI }
BEGIN
  TRY
    FicINI := TIniFile.Create(fichierini);
    WITH FicINI DO BEGIN
      debugmode := ReadBool ('DEBUG', 'Active', debugmode);
      debugcolor := ReadInteger('DEBUG', 'Couleur', debugcolor);
      debugetatports := ReadBool('DEBUG', 'Etat', debugetatports);
      debugdelaietatports := ReadInteger('DEBUG', 'Delai', debugdelaietatports);
      affichehint := ReadBool('SETUP', 'Hint', affichehint);
      en8255_8254 := ReadBool('SETUP', 'en8255_8254', en8255_8254);
      base8255 := ReadInteger ('SETUP', 'Base8255', base8255);
      offset8254 := ReadInteger ('SETUP', 'offset8254', offset8254);
      FreqStr := ReadString ('SETUP', 'Quartz', FloatToStr(freqquartz));
    END; {WITH}
  FINALLY
    { De toute faon on passe par l pour retirer FicINI de la mmoire.
      Au cas o il y a eu une erreur lors de la lecture... on ne sait jamais. }
    FicINI.Free;
  END; {TRY}
END; {PROCEDURE LireFichierINI}



PROCEDURE TfrmMain.EcrireFichierINI(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Inscrit dans le fichier INI l'tat des diffrentes
                    constantes qui ont pu changer durant l'utilisation du
                    programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
VAR
  FicINI: TIniFile;
BEGIN
  TRY
    FicINI := TIniFile.Create(fichierini);
    WITH FicINI DO BEGIN
      WriteBool ('DEBUG', 'Active', debugmode);
      WriteInteger('DEBUG', 'Couleur', debugcolor);
      WriteBool('DEBUG', 'Etat', debugetatports);
      WriteInteger('DEBUG', 'Delai', debugdelaietatports);
      WriteBool('SETUP', 'Hint', affichehint);
      WriteBool('SETUP', 'en8255_8254', en8255_8254);
      WriteInteger ('SETUP', 'Base8255', base8255);
      WriteString ('SETUP', 'Quartz', FloatToStr(frmMain.PIT8254.quartz));
      WriteInteger ('SETUP', 'offset8254', offset8254);
    END; {WITH}
  FINALLY
    FicINI.Free;
  END; {TRY}
END; {PROCEDURE LireFichierINI}
               


PROCEDURE TfrmMain.DisplayHint(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Affiche dans la barre d'tat tous les hint rencontrs
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : L'affichage dans la barre d'tat ne peut tre dsactiv
                    par l'cran de configuration. Donc mme si on affiche pas
                    le hint dans une infobulle, on l'affiche dans la barre
                    d'tat
 -----------------------------------------------------------------------------}
BEGIN
  pnlStatuts.Caption := Application.Hint;
END; {PROCEDURE TForm1.DisplayHint}



{=============================================================================}
{ DEBUG --------------------------------------------------------------- Debug }
{=============================================================================}



PROCEDURE TfrmMain.timerEtatPortsTimer(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Affiche sur l'cran principal l'tat du PPI8255 et du
                    PIT8254 toutes les "debugdelaietatports" [ms] si
                    debugetatports est  TRUE (donc que le timer
                    "timerEtatPorts" est activ)
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Des valeurs sont affiches  l'cran
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  { * 8255 * Adresse de base }                                 { *-* 8255 *-* }
  lblBase55.Caption := 'Base = ' + IntToHex(PPI8255.Adresse,3) + 'h';
  { * 8255 * Valeurs prsentes sur les ports }
  lblPortA.Caption := 'A = ' + IntToHex(PPI8255.PortA,2) + 'h';
  lblPortC.Caption := 'B = ' + IntToHex(PPI8255.PortB,2) + 'h';
  lblPortB.Caption := 'C = ' + IntToHex(PPI8255.PortC,2) + 'h';
  { * 8255 * Configuration des ports }
  CASE PPI8255.ModePortA OF
    mpIndefini : lblModePortA.Caption := 'A => Indfini';
    mpEntree   : lblModePortA.Caption := 'A => Entre';
    mpSortie   : lblModePortA.Caption := 'A => Sortie';
  END; {CASE OF}
  CASE PPI8255.ModePortB OF
    mpIndefini : lblModePortB.Caption := 'B => Indfini';
    mpEntree   : lblModePortB.Caption := 'B => Entre';
    mpSortie   : lblModePortB.Caption := 'B => Sortie';
  END; {CASE OF}
  CASE PPI8255.ModePortC OF
    mpIndefini : lblModePortC.Caption := 'C => Indfini';
    mpEntree   : lblModePortC.Caption := 'C => Entre';
    mpSortie   : lblModePortC.Caption := 'C => Sortie';
  END; {CASE OF}
  { * 8254 * Adresse de base }                                 { *-* 8254 *-* }
  lblBase54.Caption := 'Base = ' + IntToHex(PIT8254.Adresse,3) + 'h';
  { * 8254 * Configuration des compteurs }
  CASE PIT8254.ModeCompteur0 OF
    mcIndefini   : lblModeCnt0.Caption := '0 => Indfini';
    mcGenerateur : lblModeCnt0.Caption := '0 => Gnrateur';
  END; {CASE OF}
  CASE PIT8254.ModeCompteur1 OF
    mcIndefini   : lblModeCnt1.Caption := '1 => Indfini';
    mcGenerateur : lblModeCnt1.Caption := '1 => Gnrateur';
  END; {CASE OF}
  CASE PIT8254.ModeCompteur2 OF
    mcIndefini   : lblModeCnt2.Caption := '2 => Indfini';
    mcGenerateur : lblModeCnt2.Caption := '2 => Gnrateur';
  END; {CASE OF}
  { * 8254 * Valeurs prsentes sur les compteurs }
  lblCompteur0.Caption := '0 = ' + IntToStr(PIT8254.Compteur0);
  lblCompteur1.Caption := '1 = ' + IntToStr(PIT8254.Compteur1);
  lblCompteur2.Caption := '2 = ' + IntToStr(PIT8254.Compteur2);
  { * 8254 * Frquence du quartz utilis }
  lblQuartz.Caption := FloatToStr(PIT8254.Quartz) + ' [Hz]';
END; {PROCEDURE timerEtatPortsTimer}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



PROCEDURE TfrmMain.FormCreate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisations du programme lors de la cration de la
                    fentre principale.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... :
 -----------------------------------------------------------------------------}
BEGIN
  Caption := Application.Title;                           { Affichage du titre}
  Application.OnHint := DisplayHint;                     { Affichage des hint }
  LireFichierINI(Sender);                            { Lecture du fichier INI }
  PPI8255.Adresse := base8255;                  { Initialisation des adresses }
  {2.01: L'espace entres les adresses de bases du PPI8255 et du PIT 8254 n'est
          pas fixe, mais il est dfini par la constante offset8254
  PIT8254.Adresse := base8255 + 8; }
  PIT8254.Adresse := base8255 + offset8254;
  TRY                              { Initialisation de la frquence du quartz }
    freqquartz := StrToFloat(FreqStr);
    frmMain.PIT8254.Quartz := freqquartz;
  EXCEPT
    { ERREUR lors de la conversion STRING -> FLOAT. On initialise alors avec
      une valeur correcte (enfin, esprons !) }
    freqquartz := 6000000;
    frmMain.PIT8254.Quartz := freqquartz;
  END; {TRY}
END; {PROCEDURE FormCreate}


PROCEDURE TfrmMain.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisations du programme lors de la cration de la
                    fentre principale.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... :
 -----------------------------------------------------------------------------}
BEGIN
  { Activation du PPI8255 et du PIT8254 si on est pas en mode DEBUG }
  PPI8255.Enabled := en8255_8254 AND (NOT debugmode);
  PIT8254.Enabled := en8255_8254 AND (NOT debugmode);
  { Activation des menus si le 8255 et le 8254 sont activs }
  mEtatPorts8255.Enabled := en8255_8254;
  mChenillard.Enabled := en8255_8254;
  mPattern.Enabled := en8255_8254;
  mLecture.Enabled := en8255_8254;
  mEcriture.Enabled := en8255_8254;
  mChronogramme.Enabled := en8255_8254;
  mGenerateur.Enabled := en8255_8254;
  mFrequencemetre.Enabled := en8255_8254;
  { Affichage de l'tat des ports et des compteurs }
  WITH timerEtatPorts DO BEGIN
    Enabled := debugetatports;
    {2.01: Et si on initialisait l'intervalle du timer, a ne serait pas
            mieux ?}
    Interval := debugdelaietatports;
  END; {WITH}
  pnlDebug.Visible := debugetatports;
  IF debugetatports THEN timerEtatPortsTimer(Sender);
END; {PROCEDURE FormActivate}


PROCEDURE TfrmMain.FormClose(Sender: TObject; VAR Action: TCloseAction);
{-----------------------------------------------------------------------------
  BUT ........... : Sauvegarde des paramtres en quittant le programme, soit
                    lors de la fermeture de la  fentre principale.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le type TCloseEvent de OnClose a un paramtre Action. La
                    valeur du paramtre Action dtermine si la fiche peut
                    effectivement tre ferme. Les valeurs possibles de Action
                    sont :
                    Valeur	Signification
                    -----------------------------------------------------------
                    caNone	La fiche n'a pas le droit de se fermer, donc il
                                ne se passe rien.
                    caHide	La fiche n'est pas ferme, juste cache.
                                L'application peut toujours accder  une fiche
                                cache.
                    caFree	La fiche est ferme et la mmoire alloue  la
                                fiche libre.
                    caMinimize	La fiche n'est pas ferme, juste rduite en
                                icne. C'est l'action par dfaut des fiches
                                enfant MDI.
 -----------------------------------------------------------------------------}
BEGIN
  EcrireFichierINI(Sender);
END; {PROCEDURE FormClose}



{=============================================================================}
{ MENU FICHIER ------------------------------------------------- Menu fichier }
{=============================================================================}



PROCEDURE TfrmMain.mQuitterClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Quitte le programme par Fichier|Quitter
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - Identique  ALT-F4
                    - La mthode Close ferme une fiche. L'appel de la
                      mthode Close d'une fiche correspond  la slection par
                      l'utilisateur de l'lment de menu Fermer dans le menu
                      systme. La mthode Close appelle d'abord la mthode
                      CloseQuery pour dterminer si la fiche peut tre ferme.
                      Si CloseQuery renvoie False, l'opration de fermeture est
                      interrompue. Dans le cas o CloseQuery renvoie True, le
                      code rattach  l'vnement OnClose s'excute.
                      Le paramtre CloseAction de l'vnement OnClose contrle
                      la faon dont s'opre la fermeture effective de la fiche.
 -----------------------------------------------------------------------------}
BEGIN
  Close;
END; {PROCEDURE mQuitterClick}


PROCEDURE TfrmMain.mConfigurationProgrammeClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue pour la configuration du
                    programme.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : L'tat des constantes du programme peuvent tre modifies
  REMARQUE(S) ... : Identique  F12
 -----------------------------------------------------------------------------}
BEGIN
  frmCfgProgramme.ShowModal; { Appel de la bote de dialogue }
  FormActivate(Sender); { Rinitialisation des contrles, car il est possible
                          que la configuration ait chang }
END; {PROCEDURE mConfigurationProgrammeClick}



{=============================================================================}
{ MENU AIDE ------------------------------------------------------- Menu aide }
{=============================================================================}



PROCEDURE TfrmMain.mHelpIndexClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de l'index du ficher d'aide
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Identique  F1
 -----------------------------------------------------------------------------}
BEGIN
  Application.HelpCommand(HELP_CONTENTS, 0);
END; {PROCEDURE mHelpIndexClick}


PROCEDURE TfrmMain.AProposClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Afiche la fentre "A propos de..."
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Il y a un cran cach dans la fentre "A propos de..."
 -----------------------------------------------------------------------------}
BEGIN
  frmAbout.ShowModal;
END; {PROCEDURE AProposClick}



{=============================================================================}
{ MENU 8255 ------------------------------------------------------- Menu 8255 }
{=============================================================================}



PROCEDURE TfrmMain.mAdresseBaseClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Configuration de l'adresse de base du 8255 et du 8254
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les constantes "base8255", "offset8254" et "en8255_8254"
                    peuvent tre modifies.
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  frmAdresseBase.ShowModal;             { Affiche la fentre de configuration }
  FormActivate(Sender);  { Si une des constantes a t modifies, rinitialise
                           les contrles de la fentres principale }
END; {PROCEDURE TfrmMain.mAdresseBaseClick}


PROCEDURE TfrmMain.mEtatPorts8255Click(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue pour la modification de
                    l'tat des ports
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les proprits ModePortA, ModePortB et ModePortC du
                    composant TPPI8255 seront configures selon les dsirs de
                    l'utilisateur.
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  frmCfgPorts.ShowModal;
  {2.01: Ca, il n'y a pas besoin de le faire...
  FormActivate(Sender); }
END; {PROCEDURE mEtatPorts8255Click}


PROCEDURE TfrmMain.mLectureClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue pour la lecture de la valeur
                    actuellement prsente sur un des ports du PPI8255
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Les proprits ModePortA, ModePortB et ModePortC du
                    composant TPPI8255 seront configures en entre lors de la
                    lecture sur le port correspondant.
 -----------------------------------------------------------------------------}
BEGIN
  frmLire.ShowModal;
END; {PROCEDURE mLectureClick}


PROCEDURE TfrmMain.mEcritureClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue pour l'criture d'une valeur
                    sur un des ports du PPI8255
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Les proprits ModePortA, ModePortB et ModePortC du
                    composant TPPI8255 seront configures en sortie lors de
                    l'criture de la valeur sur le port correspondant.
 -----------------------------------------------------------------------------}
BEGIN
  frmEcrire.ShowModal;
END; {PROCEDURE mEcritureClick}


PROCEDURE TfrmMain.mChenillardClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue de gestion du chenillard
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Une des proprits ModePortx du composant TPPI8255 sera
                    configur en sortie, et les autres en entres
 -----------------------------------------------------------------------------}
BEGIN
  frmChenillard.ShowModal;
END; {PROCEDURE mChenillardClick}


PROCEDURE TfrmMain.PPI8255ChenillardBouge(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Affiche l'tat du chenillard lorsque le chenillard vient de
                    changer d'tat
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  frmChenillard.MAJEtatLEDs(Sender); { L'afichage de l'tat des LEDs se fait
                                       dans l'unit UChen (fiche frmChenillard)
                                       par la mthode MAJEtatLEDs. }
END; {PROCEDURE PPI8255ChenillardBouge}


PROCEDURE TfrmMain.mPatternClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Appel de la bote de dialogue de gestion du test de pattern
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Une des proprits ModePortx du composant TPPI8255 sera
                    configur en sortie, et les autres en entres
 -----------------------------------------------------------------------------}
BEGIN
  frmPattern.ShowModal;
END; {PROCEDURE mPatternClick}


PROCEDURE TfrmMain.PPI8255ErrorPattern(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Gestion des erreurs lors du test de transfert de pattern.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : L'afichage de l'erreur dtecte se fait dans l'unit
                    UPattern (fiche frmPattern) par la mthode AjouteErreur.
 -----------------------------------------------------------------------------}
BEGIN
  frmPattern.AjouteErreur(Sender, FALSE);
                                  {  }
                                  { +-- TRUE = Sans ajout  la liste }
END; {PROCEDURE PPI8255ErrorPattern}


PROCEDURE TfrmMain.mChronogrammeClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Petite boucle de test pour relev le chronogramme du
                    PPI 8255
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Ne pas utiliser cette possibilit du programme, mais le
                    programme DOS "Chrono.exe" qui sera plus rapide et moins
                    perturb par le multitche de Windows
 -----------------------------------------------------------------------------}
BEGIN
  frmChronoPPI.ShowModal;
END; {PROCEDURE mChronogrammeClick}



{=============================================================================}
{ MENU 8254 ------------------------------------------------------- Menu 8254 }
{=============================================================================}



PROCEDURE TfrmMain.mFrquenceQuartzClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Slection de la frquence du quartz
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : La proprit Quartz du composant PIT8254 est mise  jour
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  frmQuartz.ShowModal;
  IF frmQuartz.ModalResult=mrOK THEN BEGIN  { 2.01: MAJ de la constante.. }
    freqquartz := PIT8254.Quartz;           { ..freqquartz & de la variable.. }
    FreqStr := FloatToStr(freqquartz);      { ..FreqStr si la frquence a.. }
  END; {IF}                                 { ..chang }
END; {PROCEDURE mFrquenceQuartzClick}


PROCEDURE TfrmMain.mGenerateurClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Gnrateur de frquence
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Les proprit ModeCompteurx du composant PIT8254 sont MAJ
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  frmgenerateur.ShowModal;
END; {PROCEDURE mGenerateurClick}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



procedure TfrmMain.mFrequencemetreClick(Sender: TObject);
begin
  frmFrequencemetre.ShowModal;
end;

INITIALIZATION
END. {UNIT Uprincpl}

