UNIT Ucfgprts;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UCFGPRTS.PAS
  BUT            : Configuration des ports du PPI 8255 en entre ou en sortie
  AUTEUR         : Stphane Claus
  DATE           : Dcembre 1996

  MODIFIE LE     : 12.04.1997  -  EDT:01
  RAISON         : - Ajout de commentaires

  REMARQUES      :
 -----------------------------------------------------------------------------}



{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, ExtCtrls;


TYPE
  TfrmCfgPorts = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    rgrpPortA: TRadioGroup;
    rgrpPortB: TRadioGroup;
    rgrpPortC: TRadioGroup;
    bitbtnCancel: TBitBtn;
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE bitbtnOKClick(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmCfgPorts: TfrmCfgPorts;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  UPrincpl, VCL8255;


PROCEDURE TfrmCfgPorts.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation de la fiche en fonction des paramtres
                    actuels du programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Caption := Application.Title;                         { Titre de la fentre }
  IF debugmode THEN BEGIN            { Couleur de la fentre et des contrles }
    Color := debugcolor;
  END {IF}
  ELSE BEGIN
    Color := clBtnFace;
  END; {ELSE}
  bitbtnOK.ShowHint := affichehint;                    { Affichage des Hint ? }
  bitbtnAide.ShowHint := affichehint;
  rgrpPortA.ShowHint := affichehint;
  rgrpPortB.ShowHint := affichehint;
  rgrpPortC.ShowHint := affichehint;
  CASE frmMain.PPI8255.ModePortA OF   { Init. en f(x) des paramtres du prog. }
    mpIndefini : rgrpPortA.ItemIndex := -1;
    mpEntree   : rgrpPortA.ItemIndex := 0;
    mpSortie   : rgrpPortA.ItemIndex := 1;
  END; {CASE OF}
  CASE frmMain.PPI8255.ModePortB OF
    mpIndefini : rgrpPortB.ItemIndex := -1;
    mpEntree   : rgrpPortB.ItemIndex := 0;
    mpSortie   : rgrpPortB.ItemIndex := 1;
  END; {CASE OF}
  CASE frmMain.PPI8255.ModePortC OF
    mpIndefini : rgrpPortC.ItemIndex := -1;
    mpEntree   : rgrpPortC.ItemIndex := 0;
    mpSortie   : rgrpPortC.ItemIndex := 1;
  END; {CASE OF}
END; {PROCEDURE FormActivate}


PROCEDURE TfrmCfgPorts.bitbtnOKClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Prend en compte les choix des utilisateurs et configure
                    le PPI en fonction de ces choix
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  IF NOT debugmode THEN BEGIN
    CASE rgrpPortA.ItemIndex OF
      -1 : frmMain.PPI8255.ModePortA := mpIndefini;
       0 : frmMain.PPI8255.ModePortA := mpEntree;
       1 : frmMain.PPI8255.ModePortA := mpSortie;
    END; {CASE OF}
    CASE rgrpPortB.ItemIndex OF
      -1 : frmMain.PPI8255.ModePortB := mpIndefini;
       0 : frmMain.PPI8255.ModePortB := mpEntree;
       1 : frmMain.PPI8255.ModePortB := mpSortie;
    END; {CASE OF}
    CASE rgrpPortC.ItemIndex OF
      -1 : frmMain.PPI8255.ModePortC := mpIndefini;
       0 : frmMain.PPI8255.ModePortC := mpEntree;
       1 : frmMain.PPI8255.ModePortC := mpSortie;
    END; {CASE OF}
  END; {IF}
END; {PROCEDURE bitbtnOKClick}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Ucfgprts}
