UNIT Usmall_2;
 {-----------------------------------------------------------------------------
  NOM DE L'UNITE : USMALL_2.PAS
  BUT            : Test du composant PIT8254
  AUTEUR         : Michael Amarantidis / Stphane Claus
  DATE           : Fvrier / Mars 1997

  MODIFIE LE     :
  RAISON         :

  REMARQUES      : - Cette unit est une version (trs) light du programme
                     ETIPCBUS.
                   - Aucun control n'est effectu, et il peut y avoir des
                     plante lors de l'utilisation.
                   - Une fois le gnrateur lanc, il n'est plus possible de
                     l'arrter !
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}


USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, Spin, ExtCtrls,
  UAlnEdit, Vcl8254, Prevchek;


TYPE
  TfrmMain = CLASS(TForm)
    PIT8254: TPIT8254;
    bitbtnFermer: TBitBtn;
    grpbxGenerateur: TGroupBox;
    grpbcFacteurDivision: TGroupBox;
    lblFact1: TLabel;
    lblFact10: TLabel;
    lblFact100: TLabel;
    lblFact1000: TLabel;
    lblFact10000: TLabel;
    spnbtnFacteur1: TSpinButton;
    spnbtnFacteur10: TSpinButton;
    spnbtnFacteur100: TSpinButton;
    spnbtnFacteur1000: TSpinButton;
    spnbtnFacteur10000: TSpinButton;
    aedtFacteur: TAlignEdit;
    rgrpCompteur: TRadioGroup;
    grpbxFrequence: TGroupBox;
    lblFreqReelle: TLabel;
    lblFreqDesiree: TLabel;
    lblHz1: TLabel;
    lblHz2: TLabel;
    spnbtnChangeFreq: TSpinButton;
    aedtFreqVoulue: TAlignEdit;
    aedtFreqReelle: TAlignEdit;
    grpbxQuartz: TGroupBox;
    lblQuartz: TLabel;
    OneInstance1: TOneInstance;
    pnlInfos: TPanel;
    lblNomProjet: TLabel;
    lblNomProjet2: TLabel;
    lblAuteurs: TLabel;
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE spnbtnFacteurDownClick(Sender: TObject);
    PROCEDURE rgrpCompteurClick(Sender: TObject);
    PROCEDURE spnbtnFacteurUpClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE aedtFreqVoulueChange(Sender: TObject);
    PROCEDURE aedtFacteurChange(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmMain: TfrmMain;


{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}


{$R *.DFM}

VAR
  NoCompteurChoisi : SHORTINT;               { Choix d'un des trois compteurs }


PROCEDURE TfrmMain.FormActivate(Sender: TObject);
{ BUT: Rafrichit les infos lors de l'affichage de la fiche }
VAR
  Facteur : WORD;
BEGIN
  CASE rgrpCompteur.ItemIndex OF
    0 : BEGIN
          PIT8254.ModeCompteur0 := mcGenerateur;
          Facteur := PIT8254.Compteur0;
          aedtFacteur.Text := IntToStr(Facteur);
          aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
        END; {BRANCH OF CASE}
    1 : BEGIN
          PIT8254.ModeCompteur1 := mcGenerateur;
          Facteur := PIT8254.Compteur1;
          aedtFacteur.Text := IntToStr(Facteur);
          aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
        END; {BRANCH OF CASE}
    2 : BEGIN
          PIT8254.ModeCompteur2 := mcGenerateur;
          Facteur := PIT8254.Compteur2;
          aedtFacteur.Text := IntToStr(Facteur);
          aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
        END; {BRANCH OF CASE}
  END; {CASE OF}
  { Quartz }
  lblQuartz.Caption := FloatToStr(PIT8254.Quartz) + '[Hz]';
END; {PROCEDURE FormActivate}


PROCEDURE TfrmMain.spnbtnFacteurDownClick(Sender: TObject);
{ BUT: Diminue le facteur de division => Augmente la frquence }
VAR
  Facteur : LONGINT;
BEGIN
  CASE NoCompteurChoisi OF
    0 : Facteur := PIT8254.Compteur0;
    1 : Facteur := PIT8254.Compteur1;
    2 : Facteur := PIT8254.Compteur2;
  END;
  Dec(Facteur, Abs((Sender AS TSpinButton).Tag));
  IF Facteur < 2 THEN Facteur := 2;
  CASE NoCompteurChoisi OF
    0 : PIT8254.Compteur0 := Facteur;
    1 : PIT8254.Compteur1 := Facteur;
    2 : PIT8254.Compteur2 := Facteur;
  END;
  aedtFacteur.Text := IntToStr(Facteur);
  aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
  IF (Sender AS TSpinButton).Tag < 0 THEN BEGIN
    aedtFreqVoulue.Text := FloatToStr(PIT8254.Quartz / Facteur);
  END; {IF}
END; {PROCEDURE spnbtnFacteurDownClick}


PROCEDURE TfrmMain.rgrpCompteurClick(Sender: TObject);
VAR
  Facteur : WORD;
BEGIN
  NoCompteurChoisi := rgrpCompteur.ItemIndex;
  CASE NoCompteurChoisi OF
    0 : BEGIN
          PIT8254.ModeCompteur0 := mcGenerateur;
          Facteur := PIT8254.Compteur0;
        END; {BRANCH OF CASE}
    1 : BEGIN
          PIT8254.ModeCompteur1 := mcGenerateur;
          Facteur := PIT8254.Compteur1;
        END; {BRANCH OF CASE}
    2 : BEGIN
          PIT8254.ModeCompteur2 := mcGenerateur;
          Facteur := PIT8254.Compteur2;
        END; {BRANCH OF CASE}
  END; {CASE OF}
  { Affiche les infos }
  aedtFacteur.Text := IntToStr(Facteur);
  aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
  { Active les autres contrles }
  grpbcFacteurDivision.Enabled := TRUE;
  grpbxFrequence.Enabled := TRUE;
END; {PROCEDURE rgrpCompteurClick}


PROCEDURE TfrmMain.spnbtnFacteurUpClick(Sender: TObject);
{ BUT: Diminue le facteur de division => Augmente la frquence }
VAR
  Facteur : LONGINT;
BEGIN
  CASE NoCompteurChoisi OF
    0 : Facteur := PIT8254.Compteur0;
    1 : Facteur := PIT8254.Compteur1;
    2 : Facteur := PIT8254.Compteur2;
  END;
  Inc(Facteur, Abs((Sender AS TSpinButton).Tag));
  IF Facteur > 65535 THEN Facteur := 65535;
  CASE NoCompteurChoisi OF
    0 : PIT8254.Compteur0 := Facteur;
    1 : PIT8254.Compteur1 := Facteur;
    2 : PIT8254.Compteur2 := Facteur;
  END; {CASE OF}
  aedtFacteur.Text := IntToStr(Facteur);
  aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
  IF (Sender AS TSpinButton).Tag < 0 THEN BEGIN
    aedtFreqVoulue.Text := FloatToStr(PIT8254.Quartz / Facteur);
  END; {IF}
END; {PROCEDURE spnbtnFacteurUpClick}


PROCEDURE TfrmMain.FormCreate(Sender: TObject);
{ BUT: Quelques initialisations lors de la cration de la fiche }
BEGIN
  {-- Affichage du titre}
  Caption := Application.Title;
END; {PROCEDURE FormCreate}


PROCEDURE TfrmMain.aedtFreqVoulueChange(Sender: TObject);
{ BUT: Change de frquence, en prenant celle que l'utilisateur dsire }
VAR
  Frequence  : EXTENDED;
  FacteurSup : LONGINT;
  FacteurInf : LONGINT;
  Facteur    : LONGINT;
  FreqSup    : REAL;
  FreqInf    : REAL;
BEGIN
  TRY
    { On voit rouge ! }
    aedtFreqVoulue.Color := clRed;
    {-- Lit la frquence saisie }
    Frequence := StrToFloat(aedtFreqVoulue.Text);
    {-- Hors limite ? }
    IF Frequence > (PIT8254.Quartz / 2) THEN BEGIN
      Frequence := PIT8254.Quartz / 2;
    END; {IF}
    IF Frequence < (PIT8254.Quartz / 65535) THEN BEGIN
      Frequence := PIT8254.Quartz / 65535;
    END; {IF}
    {-- Cherche le facteur de division le plus proche }
    FacteurSup   := Round(PIT8254.Quartz / Frequence);
    FacteurInf   := Trunc(Int(PIT8254.Quartz / Frequence));
    {-- Calcule les frquence avec les facteurs trouvs prcedemment }
    FreqSup := PIT8254.Quartz / FacteurInf;
    FreqInf := PIT8254.Quartz / FacteurSup;
    {-- Recherche le facteur de division qui nous permet d'tre le plus proche
        de la frquence voulue }
    IF ((Frequence = FreqSup) OR
       ((FreqSup - Frequence) < (Frequence - FreqInf))) THEN BEGIN
      Facteur := FacteurInf;
    END {IF}
    ELSE IF ((Frequence = FreqInf) OR
            ((FreqSup - Frequence) > (Frequence - FreqInf))) THEN BEGIN
      Facteur := FacteurSup;
    END; {ELSE IF}
    {-- Est-ce que les facteurs trouvs sont acceptables ?}
    IF Facteur < 2 THEN Facteur := 2;
    IF Facteur > 65535 THEN Facteur := 65535;
    {-- Change la frquence et affiche }
    CASE NoCompteurChoisi OF
      0 : PIT8254.Compteur0 := Facteur;
      1 : PIT8254.Compteur1 := Facteur;
      2 : PIT8254.Compteur2 := Facteur;
    END; {CASE OF}
    {-- Affiche les infos }
    aedtFacteur.Text := IntToStr(Facteur);
    aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
    {-- Couleur standard }
    aedtFreqVoulue.Color := clWindow;
  EXCEPT
    {-- Valeur incorrecte }
    aedtFreqVoulue.Color := clRed;                          { On voit rouge ! }
  END; {TRY}
END; {PROCEDURE aedtFreqVoulueChange}


PROCEDURE TfrmMain.aedtFacteurChange(Sender: TObject);
{ BUT: Change de facteur de division en saisissant simplement le facteur }
VAR
  Facteur : LONGINT;
BEGIN
  TRY
    { It's Red }
    aedtFacteur.Color := clRed;
    Facteur := StrToInt(aedtFacteur.Text);
    IF ((Facteur >= 2) AND (Facteur <= 65535)) THEN BEGIN
      aedtFreqReelle.Text := FloatToStr(PIT8254.Quartz / Facteur);
      CASE NoCompteurChoisi OF
        0 : PIT8254.Compteur0 := Facteur;
        1 : PIT8254.Compteur1 := Facteur;
        2 : PIT8254.Compteur2 := Facteur;
      END; {CASE OF}
      aedtFacteur.Color := clWindow;
    END; {IF}
  EXCEPT
    { It's Red }
    aedtFacteur.Color := clRed;
  END; {TRY}
END; {PROCEDURE aedtFacteurChange}


INITIALIZATION
  NoCompteurChoisi := -1;
END. {UNIT Usmall_2}
