UNIT Ulit;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : ULIT.PAS
  BUT            : Lit la valeur prsente sur un des ports du PPI8255
  AUTEUR         : Stphane Claus
  DATE           : Dcembre 1996

  MODIFIE LE     : 12.04.1997  -  EDT:01
  RAISON         : - Ajout de commentaires
                   - Affiche la base

  MODIFIE LE     :
  RAISON         :

  REMARQUES      :
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, ExtCtrls;


TYPE
  TfrmLire = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    grpbxPortA: TGroupBox;
    bitbtnLitPortA: TBitBtn;
    grpbxPortB: TGroupBox;
    bitbtnLitPortB: TBitBtn;
    grpbxPortC: TGroupBox;
    bitbtnLitPortC: TBitBtn;
    pnlPortA: TPanel;
    pnlPortB: TPanel;
    pnlPortC: TPanel;
    lblPortA: TLabel;
    lblPortB: TLabel;
    lblPortC: TLabel;
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE LitPort(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmLire: TfrmLire;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  UPrincpl, Vcl8255;


PROCEDURE TfrmLire.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation de la fiche en fonction des paramtres
                    actuels du programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Caption := Application.Title;                         { Titre de la fentre }
  IF debugmode THEN BEGIN            { Couleur de la fentre et des contrles }
    Color := debugcolor;
    pnlPortA.Color := debugcolor;
    pnlPortB.Color := debugcolor;
    pnlPortC.Color := debugcolor;
  END {IF}
  ELSE BEGIN
    Color := clBtnFace;
    pnlPortA.Color := clBtnFace;
    pnlPortB.Color := clBtnFace;
    pnlPortC.Color := clBtnFace;
  END; {ELSE}
  bitbtnLitPortA.ShowHint := affichehint;                { Affichage des Hint }
  bitbtnLitPortB.ShowHint := affichehint;
  bitbtnLitPortC.ShowHint := affichehint;
  lblPortA.Caption := '';  { Efface les valeurs qui ont t lues prcedemment }
  lblPortB.Caption := '';
  lblPortC.Caption := '';
END; {PROCEDURE FormActivate}


PROCEDURE TfrmLire.LitPort(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Lit ce qu'il y a actuellement sur un des ports
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le port choisi est configur en entre
 -----------------------------------------------------------------------------}
BEGIN
  CASE (Sender AS TBitbtn).TAG OF
    1 : IF NOT debugmode THEN BEGIN
          frmMain.PPI8255.ModePortA := mpEntree;
          {EDT:01 Affiche la base ( + ' h') }
          lblPortA.Caption := IntToHex(frmMain.PPI8255.PortA, 2) + ' h';
        END; {IF / BRANCH OF CASE}
    2 : IF NOT debugmode THEN BEGIN
          frmMain.PPI8255.ModePortB := mpEntree;
          {EDT:01 Affiche la base ( + ' h') }
          lblPortB.Caption := IntToHex(frmMain.PPI8255.PortB, 2) + ' h';
        END; {IF / BRANCH OF CASE}
    3 : IF NOT debugmode THEN BEGIN
          frmMain.PPI8255.ModePortC := mpEntree;
          {EDT:01 Affiche la base ( + ' h') }
          lblPortC.Caption := IntToHex(frmMain.PPI8255.PortC, 2) + ' h';
        END; {IF / BRANCH OF CASE}
  END; {CASE OF}
END; {PROCEDURE LitPort}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Ulit}
