UNIT Ucfgprgm;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UCFGPRGM.PAS
  BUT            : Configuration gnrale du programme
  AUTEUR         : Stphane Claus
  DATE           : Dcembre 1996

  MODIFIE LE     : 12.04.1997  -  EDT:01
  RAISON         : - Ajout de commentaires

  REMARQUES      :
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons;


TYPE
  TfrmCfgProgramme = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    ColorDialog: TColorDialog;
    grpbxDebug: TGroupBox;
    chkbxModeDebug: TCheckBox;
    bitbtnCouleurDebug: TBitBtn;
    grpbxEtatPorts: TGroupBox;
    chkbxAffichageEtatPorts: TCheckBox;
    scrlbarIntervalleRefreshPorts: TScrollBar;
    lblIntervalle: TLabel;
    grpbxBullesAides: TGroupBox;
    chkbxInfobulles: TCheckBox;
    PROCEDURE bitbtnCouleurDebugClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE scrlbarIntervalleRefreshPortsChange(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmCfgProgramme: TfrmCfgProgramme;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  UPrincpl;


PROCEDURE TfrmCfgProgramme.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation de la fiche en fonction des paramtres
                    actuels du programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  Caption := Application.Title;                         { Titre de la fentre }
  bitbtnOK.ShowHint := affichehint;                    { Affichage des Hint ? }
  bitbtnAide.ShowHint := affichehint;
  chkbxModeDebug.ShowHint := affichehint;
  bitbtnCouleurDebug.ShowHint := affichehint;
  chkbxAffichageEtatPorts.ShowHint := affichehint;
  scrlbarIntervalleRefreshPorts.ShowHint := affichehint;
  chkbxInfobulles.ShowHint := affichehint;
  ColorDialog.Color := debugcolor;    { Init. en f(x) des paramtres du prog. }
  chkbxModeDebug.Checked := debugmode;
  scrlbarIntervalleRefreshPorts.Position := debugdelaietatports;
  lblIntervalle.Caption := 'Intervalle = ' + IntToStr(debugdelaietatports);
  lblIntervalle.Caption := lblIntervalle.Caption + ' [ms]';
  chkbxAffichageEtatPorts.Checked := debugetatports;
  chkbxInfobulles.Checked := affichehint;
END; {PROCEDURE FormActivate}


PROCEDURE TfrmCfgProgramme.bitbtnCouleurDebugClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Change la couleur des fentres en mode Debug
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le composant Bote de dialogue des couleurs (ColorDialog)
                    cre une bote de dialogue Couleurs qui vous permet de
                    dfinir, en mode excution, la couleur de n'importe quel
                    composant dot de la proprit Color.
 -----------------------------------------------------------------------------}
BEGIN
  IF ColorDialog.Execute THEN BEGIN           { Appel de la boite de dialogue }
    debugcolor := ColorDialog.Color;            { Rcupre la couleur choisie }
  END; {IF}
END; {PROCEDURE bitbtnCouleurDebugClick}


PROCEDURE TfrmCfgProgramme.FormClose(Sender: TObject; VAR Action: TCloseAction);
{-----------------------------------------------------------------------------
  BUT ........... : Mise  jour des constantes du programme lors de la
                    fermeture de la fiche
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le type TCloseEvent de OnClose a un paramtre Action. La
                    valeur du paramtre Action dtermine si la fiche peut
                    effectivement tre ferme. Les valeurs possibles de Action
                    sont :
                    Valeur	Signification
                    -----------------------------------------------------------
                    caNone	La fiche n'a pas le droit de se fermer, donc il
                                ne se passe rien.
                    caHide	La fiche n'est pas ferme, juste cache.
                                L'application peut toujours accder  une fiche
                                cache.
                    caFree	La fiche est ferme et la mmoire alloue  la
                                fiche libre.
                    caMinimize	La fiche n'est pas ferme, juste rduite en
                                icne. C'est l'action par dfaut des fiches
                                enfant MDI.
 -----------------------------------------------------------------------------}
BEGIN
  debugmode := chkbxModeDebug.Checked;
  debugdelaietatports := scrlbarIntervalleRefreshPorts.Position;
  debugetatports := chkbxAffichageEtatPorts.Checked;
  affichehint := chkbxInfobulles.Checked;
END; {PROCEDURE FormClose}


PROCEDURE TfrmCfgProgramme.scrlbarIntervalleRefreshPortsChange(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Mise  jour du label Intervalle de rafrachissement de
                    l'tat des ports
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  { Lit la position actuelle }
  debugdelaietatports := scrlbarIntervalleRefreshPorts.Position;
  { Conversion en une string }
  lblIntervalle.Caption := 'Intervalle = ' + IntToStr(debugdelaietatports);
  { Ajout de l'unit }
  lblIntervalle.Caption := lblIntervalle.Caption + ' [ms]';
END; {PROCEDURE scrlbarIntervalleRefreshPortsChange}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Ucfgprgm}
