UNIT Ucfgbs55;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UCFGBS55.PAS
  BUT            : Configuration de l'adresse de base du PPI8255 et du PIT8254
  AUTEUR         : Stphane Claus
  DATE           : Dcembre 1996

  MODIFIE LE     : 14.02.1997  -  EDT:01
  RAISON         : Adaptation pour le choix des deux adresses simultanment:
                   8255 + 8254, et non pas uniquement pour le PPI8255.

  MODIFIE LE     : 11.03.1997  -  EDT:02
  RAISON         : - Ajout le dcodage d'adresse pour J96-J98.
                   - Possibilit de choisir l'offset pour le PIT8254

  MODIFIE LE     : 12.04.1997  -  EDT:03
  RAISON         : - Ajout de commentaires
                   - Fusionn les procdures ChangeAdresse et ChangeAdresse2
                   - Correction bug dans spnbtnChangeOffsetDownClick et
                     spnbtnChangeOffsetUpClick

  REMARQUES      : IL DOIT Y AVOIR UN BUG LA DEDANS, OU JE N'AI PAS TOUT
                   COMPRIS LE DECODAGE D'ADRESSES.... CAR UNE SEULE ADRESSE
                   EST SELECTIONNABLE: 300h TOUTES LES AUTRES NE FONT PAS
                   PARTIE DE LA PLAGE AUTORISEE !

                   Mais non, il n'y a pas de bug. Il faut juste rajouter le
                   dcodage possible avec J96, J97 et J98... Cf. modifs de
                   l'EDT 02
-----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, ExtCtrls, Spin;


TYPE
  TfrmAdresseBase = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    bitbtnCancel: TBitBtn;
    grpbxSW1: TGroupBox;
    chkbxNotUsed1: TCheckBox;
    chkbxEnabled: TCheckBox;
    chkbxA9: TCheckBox;
    chkbxA8: TCheckBox;
    chkbxA7: TCheckBox;
    chkbxA6: TCheckBox;
    chkbxA5: TCheckBox;
    chkbxNotUsed3: TCheckBox;
    grpbxAdresse: TGroupBox;
    pnlAdresse8255: TPanel;
    lblAdresse: TLabel;
    grpbxEtat: TGroupBox;
    pnlEtat: TPanel;
    lblEtat: TLabel;
    grpbxLegende: TGroupBox;
    chkbxReserve: TCheckBox;
    chkbxOFF: TCheckBox;
    chkbxON: TCheckBox;
    grpbxJ96_J97_J98: TGroupBox;
    rgrpJ97: TRadioGroup;
    rgrpJ96: TRadioGroup;
    rgrpJ98: TRadioGroup;
    GroupBox1: TGroupBox;
    lblOffset: TLabel;
    spnbtnChangeOffset: TSpinButton;
    PROCEDURE ChangeAdresse(Sender: TObject);
    PROCEDURE bitbtnOKClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE chkbxEnabledClick(Sender: TObject);
    PROCEDURE spnbtnChangeOffsetDownClick(Sender: TObject);
    PROCEDURE spnbtnChangeOffsetUpClick(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
    PROCEDURE AfficheCroixAdresse(Sender: TObject);
  END; {CLASS}


VAR
  frmAdresseBase: TfrmAdresseBase;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  Uprincpl;


TYPE
  wbit = 0..15;


VAR
  AdresseBaseTmp : WORD;    { On rcupre temporairement l'adresse du PPI 8255
                              pour la retravailler dans cette unit }
  offset8254Tmp : BYTE;      { Offset temporaire entre les 2 adresses de base }


FUNCTION BitSetW(W : Word; bit : wbit) : Boolean; ASSEMBLER;
{-----------------------------------------------------------------------------
  BUT ........... : Test si un des bits et  1
  ENTREE ........ : W = Le mot qui contient un bit  tester
                    bit = Le n du bit  tester
  SORTIE ........ : TRUE = Le bit test est  1
                    FALSE = Le bit test est  0
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Je ne suis pas sr que cette fonction fonctionne sous
                    Delphi 2.0
 -----------------------------------------------------------------------------}
ASM
  MOV CL, bit
  MOV BX, 1
  SHL BX, CL
  MOV AL, 0       {positionne result  FALSE}
  TEST W, BX
  JZ @No
  INC AL          {positionne result  TRUE}
  @No:
END; {FUNCTION BitSetW}


PROCEDURE TfrmAdresseBase.ChangeAdresse(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Modification de l'adresse de base du 8255.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : - La proprit TAG des CheckBox chkbxA9, chkbxA8, chkbxA7,
                      chkbxA6 et chkbxA5 est > 0.
                    - Les CheckBox symbolisent le switch SW1
                    - La proprit TAG des RadioGroup rgrpJ97, rgrpJ96 et
                      rgrpJ98 est < 0.
                     - Ces RadioGroup symbolisent les jumpers J96  J98
 -----------------------------------------------------------------------------}
VAR
  Adresses : STRING;                                   { L'adresse  afficher }
BEGIN
  {-- MAJ de l'adresse }
  IF Tag > 0 THEN BEGIN                                           { Ckeck Box }
    IF (Sender AS TCheckBox).Checked THEN BEGIN
      AdresseBaseTmp := AdresseBaseTmp - (Sender AS TCheckBox).Tag;
    END {IF}
    ELSE BEGIN
      AdresseBaseTmp := AdresseBaseTmp + (Sender AS TCheckBox).Tag;
    END; {ELSE}
  END {IF}
  ELSE BEGIN
    IF (Sender AS TRadioGroup).ItemIndex = 0 THEN BEGIN
      AdresseBaseTmp := AdresseBaseTmp - Abs((Sender AS TRadioGroup).Tag);
    END {IF}
    ELSE BEGIN
      AdresseBaseTmp := AdresseBaseTmp + Abs((Sender AS TRadioGroup).Tag);
    END; {ELSE}
  END; {ELSE}
  {-- Affiche la  nouvelle adresse }
  (* EDT:01 - Affiche les deux adresses
  lblAdresse.Caption := IntToHex(AdresseBaseTmp, 3) + ' h'; *)
  Adresses := IntToHex(AdresseBaseTmp, 3) + ' h / ';
  Adresses := Adresses + IntToHex(AdresseBaseTmp + offset8254Tmp, 3) + ' h';
  lblAdresse.Caption := Adresses;
END; {PROCEDURE ChangeAdresse}


(*EDT:03  Cette procdure n'est plus utilise. Fusionne avec ChangeAdresse
PROCEDURE TfrmAdresseBase.ChangeAdresse2(Sender: TObject);
VAR
  Adresses : STRING;
BEGIN
  IF (Sender AS TRadioGroup).ItemIndex = 0 THEN BEGIN
    AdresseBaseTmp := AdresseBaseTmp - (Sender AS TRadioGroup).Tag;
  END {IF}
  ELSE BEGIN
    AdresseBaseTmp := AdresseBaseTmp + (Sender AS TRadioGroup).Tag;
  END; {ELSE}
  { Affiche les nouvelles adresses }
  Adresses := IntToHex(AdresseBaseTmp, 3) + ' h / ';
  Adresses := Adresses + IntToHex(AdresseBaseTmp + offset8254Tmp, 3) + ' h';
  lblAdresse.Caption := Adresses;
END; {PROCEDURE ChangeAdresse2} *)


PROCEDURE TfrmAdresseBase.AfficheCroixAdresse(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Affiche les croix aux bons endroits pour l'affichage de
                    l'adresse
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Des croix apparaissent dans les ChekBox et des points dans
                    les RadioGroup
  REMARQUE(S) ... : Il faut relire  chaque fois l'adresse de base, car elle est
                    chaque fois modifie par "ChangeAdresse"
 -----------------------------------------------------------------------------}
BEGIN
  {EDT:03 Il faut aussi lire l'adresse pour la 1re croix}
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  chkbxA9.Checked := NOT BitSetW(AdresseBaseTmp, 9);
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  chkbxA8.Checked := NOT BitSetW(AdresseBaseTmp, 8);
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  chkbxA7.Checked := NOT BitSetW(AdresseBaseTmp, 7);
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  chkbxA6.Checked := NOT BitSetW(AdresseBaseTmp, 6);
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  chkbxA5.Checked := NOT BitSetW(AdresseBaseTmp, 5);
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  IF BitSetW(AdresseBaseTmp, 4) THEN rgrpJ97.ItemIndex := 1
                                ELSE rgrpJ97.ItemIndex := 0;
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  IF BitSetW(AdresseBaseTmp, 3) THEN rgrpJ96.ItemIndex := 1
                                ELSE rgrpJ96.ItemIndex := 0;
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  IF BitSetW(AdresseBaseTmp, 2) THEN rgrpJ98.ItemIndex := 1
                                ELSE rgrpJ98.ItemIndex := 0;
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
END; {PROCEDURE AfficheCroixAdresse}


PROCEDURE TfrmAdresseBase.bitbtnOKClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Prend en compte l'adresse choisie par l'utilisateur
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : - Les constantes suivants sont mises  jour: base8255,
                      offset8254, en8255_8254
                    - La proprit Adresse des composants PPI8255 et PIT8254 de
                      la fiche principale frmMain sont mises  jour en fonction
                      des variables AdresseBaseTmp et offset8254Tmp
  REMARQUE(S) ... : - La prise en compte de la nouvelle adresse n'est possible
                      que s'il on est pas en mode DEBUG, cd que debugmode soit
                       FALSE
                    - Si l'adresse n'est pas dans la plage $300  $31F, elle
                      est refuse + message d'erreur  l'utilisateur
 -----------------------------------------------------------------------------}
VAR
  Msg : STRING;
BEGIN
  IF NOT debugmode THEN BEGIN
    IF (((AdresseBaseTmp >= $300) AND (AdresseBaseTmp <= $31F)) AND
        (((AdresseBaseTmp + offset8254Tmp) >= $300) AND
         ((AdresseBaseTmp + offset8254Tmp) <= $31F)))THEN BEGIN
      {-- Rinitialisation de l'adresse de base des 8255 et 8254 }
      frmMain.PPI8255.Adresse := AdresseBaseTmp;
      frmMain.PIT8254.Adresse := AdresseBaseTmp + offset8254Tmp;
      base8255 := AdresseBaseTmp;
      offset8254 := offset8254Tmp;
    END {IF}
    ELSE BEGIN
      {-- Adresses choisient hors de la plage autorise => on ne fait rien,
          et on signale l'erreur }
      Msg := 'L''adresse ' + IntToHex(AdresseBaseTmp, 3) + 'h ne fait ';
      Msg := Msg + 'pas partie de la plage d''adresses prvues pour les ';
      Msg := Msg + 'cartes prototypes (300h -> 31Fh).' + #10;
      Msg := Msg + 'L''adresse de base n''a pas t change.';
      {-- Affiche les croix reprsentant l'adresse de base (juste) }
      AfficheCroixAdresse(Sender);
      {-- Affiche la bote de dialogue }
      MessageDlg(Msg, mtWarning, [mbOk, mbHelp], 21);
    END; {ELSE}
    {-- 8255 et 8254 activs ? }
    en8255_8254 := chkbxEnabled.Checked;
  END; {IF}
END; {PROCEDURE bitbtnOKClick}


PROCEDURE TfrmAdresseBase.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation des contrles lors de l'ouverture de la
                    fentre
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : - Le titre de la fentre est mis  jour
                    - Sa couleur galement
                    - L'affichage des Hints est activ ou non
  REMARQUE(S) ... : Si l'adresse de base est actuellement hors de la plage
                    autorise, elle est initialise  $300
 -----------------------------------------------------------------------------}
VAR
  Adresses : STRING;
  Msg      : STRING;
BEGIN
  {-- Titre de la fentre }
  Caption := Application.Title;
  {-- Couleur de la fentre }
  IF debugmode THEN BEGIN
    Color := debugcolor;
    pnlAdresse8255.Color := debugcolor;
    pnlEtat.Color := debugcolor;
  END {IF}
  ELSE BEGIN
    Color := clBtnFace;
    pnlAdresse8255.Color := clBtnFace;
    pnlEtat.Color := clBtnFace;
  END; {ELSE}
  {-- Affichage des Hint ? }
  bitbtnOK.ShowHint := affichehint;
  bitbtnAide.ShowHint := affichehint;
  bitbtnCancel.ShowHint := affichehint;
  spnbtnChangeOffset.ShowHint := affichehint;
  rgrpJ96.ShowHint := affichehint;
  rgrpJ97.ShowHint := affichehint;
  rgrpJ98.ShowHint := affichehint;
  chkbxA5.ShowHint := affichehint;
  chkbxA6.ShowHint := affichehint;
  chkbxA7.ShowHint := affichehint;
  chkbxA8.ShowHint := affichehint;
  chkbxA9.ShowHint := affichehint;
  chkbxEnabled.ShowHint := affichehint;
  {-- Rcupre temporairement l'adresse de base du 8255 }
  AdresseBaseTmp := frmMain.PPI8255.Adresse;
  offset8254Tmp := offset8254;
  {-- Adresses correctes ? }
  IF NOT ((AdresseBaseTmp >= $300) AND (AdresseBaseTmp <= $31F)) AND
         (((AdresseBaseTmp + offset8254Tmp) >= $300) AND
          ((AdresseBaseTmp + offset8254Tmp) <= $31F)) THEN BEGIN
    {-- Adresse actuelle hors de la plage autorise => on rinitialise une
        adresse correcte, et on le signale }
    Msg := 'L''adresse ' + IntToHex(AdresseBaseTmp, 3) + 'h ne fait ';
    Msg := Msg + 'pas partie de la plage d''adresses prvues pour les ';
    Msg := Msg + 'cartes prototypes (300h -> 31Fh).' + #10;
    Msg := Msg + 'L''adresse de base a donc t initialise  300h..';
    {-- Affiche la bote de dialogue }
    MessageDlg(Msg, mtError, [mbOk, mbHelp], 21);
    {-- Rinitialisation de l'adresse de base du 8255 }
    AdresseBaseTmp := $300;
    offset8254Tmp := 8;
    {EDT:03 Les adresses du PPI et du PIT sont rinitialiss }
    frmMain.PPI8255.Adresse := AdresseBaseTmp;
    frmMain.PIT8254.Adresse := AdresseBaseTmp + offset8254Tmp;
  END; {IF}
  { Affiche les adresses }
  (* EDT:01 - Affiche les deux adresses
  lblAdresse.Caption := IntToHex(AdresseBaseTmp, 3) + ' h'; *)
  Adresses := IntToHex(AdresseBaseTmp, 3) + ' h / ';
  Adresses := Adresses + IntToHex(AdresseBaseTmp + offset8254Tmp, 3) + ' h';
  lblAdresse.Caption := Adresses;
  {-- PPI 8255 et PIT 8254 activs ?? }
  chkbxEnabled.Checked := en8255_8254;
  {-- Affiche les croix reprsentant l'adresse de base}
  AfficheCroixAdresse(Sender);
  {-- Affichage de l'offset }
  lblOffset.Caption := IntToHex(offset8254Tmp,2) + ' h';
END; {PROCEDURE FormActivate}


PROCEDURE TfrmAdresseBase.chkbxEnabledClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Indique si le PPI 8255 et le PIT8254 sont activs. Cet
                    affichage est ralis quand on clique sur la CheckBox du
                    SW 7 du Switch 1
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : Un label est mis  jour
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
BEGIN
  IF chkbxEnabled.Checked THEN lblEtat.Caption := 'Activs'
                          ELSE lblEtat.Caption := 'Dsactivs';
END; {PROCEDURE chkbx8255EnabledClick}


PROCEDURE TfrmAdresseBase.spnbtnChangeOffsetDownClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Change l'offset entre l'adresse du PPI 8255 et PIT 8254.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Cet offset est slectionn sur la carte par la sortie
                    utilise sur IC9. Il peut tre de 0 (Y0)  28 (Y9)
 -----------------------------------------------------------------------------}
VAR
  Adresses : STRING;
BEGIN
  {EDT:03  L'incrment est de 4, et non pas 2}
  IF offset8254Tmp >= 4 THEN Dec(offset8254Tmp, 4);

  lblOffset.Caption := IntToHex(offset8254Tmp, 2) + ' h';
  Adresses := IntToHex(AdresseBaseTmp, 3) + ' h / ';
  Adresses := Adresses + IntToHex(AdresseBaseTmp + offset8254Tmp, 3) + ' h';
  lblAdresse.Caption := Adresses;
END; {PROCEDURE spnbtnChangeOffsetDownClick}


PROCEDURE TfrmAdresseBase.spnbtnChangeOffsetUpClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Change l'offset entre l'adresse du PPI 8255 et PIT 8254.
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Cet offset est slectionn sur la carte par la sortie
                    utilise sur IC9. Il peut tre de 0 (Y0)  28 (Y9)
 -----------------------------------------------------------------------------}
VAR
  Adresses : STRING;
BEGIN
  {EDT:03  L'incrment est de 4, et non pas 2}
  IF offset8254Tmp <= 24 THEN Inc(offset8254Tmp, 4);

  lblOffset.Caption := IntToHex(offset8254Tmp, 2) + ' h';
  Adresses := IntToHex(AdresseBaseTmp, 3) + ' h / ';
  Adresses := Adresses + IntToHex(AdresseBaseTmp + offset8254Tmp, 3) + ' h';
  lblAdresse.Caption := Adresses;
END; {PROCEDURE spnbtnChangeOffsetUpClick}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Ucfgbs55}
