unit Ugraph;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, DigDisp, IniFiles;

type
  TfrmGraph = class(TForm)
    BitBtn1: TBitBtn;
    digdspTitre: TDigitalDisplay;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Dclarations private }
  public
    { Dclarations public }
  end;

var
  frmGraph: TfrmGraph;

implementation

{$R *.DFM}

USES
  UPrincpl;

VAR
  NombrePoints : INTEGER;
  TableauPoints : ARRAY [1..500, 1..4] OF TPoint;

PROCEDURE TfrmGraph.FormActivate(Sender: TObject);
VAR
  BoucleCourbes : INTEGER;
  BouclePoints  : INTEGER;
  FicINI        : TIniFile;         { Objet permetant de lire un fichier .INI }
  Frequence     : DOUBLE;
  Precision     : DOUBLE;
  X, Y          : INTEGER;
  SectionINI    : STRING;

BEGIN
  Caption := Application.Title;                          { Affichage du titre }
  FOR BouclePoints := 1 TO 500 DO BEGIN
    TableauPoints[BouclePoints, 1].X := 0;
    TableauPoints[BouclePoints, 1].Y := 0;
    TableauPoints[BouclePoints, 2].X := 0;
    TableauPoints[BouclePoints, 2].Y := 0;
    TableauPoints[BouclePoints, 3].X := 0;
    TableauPoints[BouclePoints, 3].Y := 0;
    TableauPoints[BouclePoints, 4].X := 0;
    TableauPoints[BouclePoints, 4].Y := 0;
  END; {FOR}

  TRY
    FicINI := TIniFile.Create(fichierini);
    WITH FicINI DO BEGIN
      FOR BoucleCourbes := 1 TO 4 DO BEGIN
        CASE BoucleCourbes OF
          1 : SectionINI := 'GRAPH 0.5';
          2 : SectionINI := 'GRAPH 1.0';
          3 : SectionINI := 'GRAPH 5.0';
          4 : SectionINI := 'GRAPH 10.0';
        END; {CASE OF}
        NombrePoints := ReadInteger(SectionINI, 'NombrePoints', 0);
        IF NombrePoints > 500 THEN NombrePoints := 500;
        FOR BouclePoints := 1 TO NombrePoints DO BEGIN
          { Lit une valeur }
          Frequence := ReadInteger(SectionINI, 'Frequence' + IntToStr(BouclePoints), 0);
          Precision := ReadInteger(SectionINI, 'Precision' + IntToStr(BouclePoints), 0);
          { Conversion }
          X := 200 - Abs(Trunc(Precision));
          Y := Abs(Trunc((35*Ln(Frequence))-100));
          { Stockage }
          TableauPoints[BouclePoints, BoucleCourbes] := Point(X, Y);
        END; {FOR}
      END; {FOR}
    END; {WITH}
  FINALLY
    { De toute faon on passe par l pour retirer FicINI de la mmoire.
      Au cas o il y a eu une erreur lors de la lecture... on ne sait jamais. }
    FicINI.Free;
  END{TRY}

end;

procedure TfrmGraph.FormPaint(Sender: TObject);
VAR
  BoucleCourbes : INTEGER;
  BouclePoints  : INTEGER;
  ValMax        : INTEGER;
BEGIN
  Canvas.Pen.Color := clGray;
  Canvas.Pen.Width := 1;
  Canvas.Pen.Style := psSolid;
  { Lignes horizontales }
  Canvas.MoveTo(53, 36 + 180);  Canvas.LineTo(474, 36 + 180);          { 90 % }
  Canvas.MoveTo(53, 36 + 160);  Canvas.LineTo(474, 36 + 160);          { 80 % }
  Canvas.MoveTo(53, 36 + 140);  Canvas.LineTo(474, 36 + 140);          { 70 % }
  Canvas.MoveTo(53, 36 + 120);  Canvas.LineTo(474, 36 + 120);          { 60 % }
  Canvas.MoveTo(53, 36 + 100);  Canvas.LineTo(474, 36 + 100);          { 50 % }
  Canvas.MoveTo(53, 36 + 080);  Canvas.LineTo(474, 36 + 080);          { 40 % }
  Canvas.MoveTo(53, 36 + 060);  Canvas.LineTo(474, 36 + 060);          { 30 % }
  Canvas.MoveTo(53, 36 + 040);  Canvas.LineTo(474, 36 + 040);          { 20 % }
  Canvas.MoveTo(53, 36 + 020);  Canvas.LineTo(474, 36 + 020);          { 10 % }
  FOR BoucleCourbes := 1 TO 4 DO BEGIN
    CASE BoucleCourbes OF
        1 : Canvas.Pen.Color := clYellow;
        2 : Canvas.Pen.Color := clRed;
        3 : Canvas.Pen.Color := clAqua;
        4 : Canvas.Pen.Color := clLime;
    END; {CASE OF}
    FOR BouclePoints := 1 TO 500 DO BEGIN
      IF (TableauPoints[BouclePoints, BoucleCourbes].X +
          TableauPoints[BouclePoints, BoucleCourbes].Y) > 0 THEN BEGIN
        Canvas.Ellipse(53 + TableauPoints[BouclePoints, BoucleCourbes].Y - 1,
                       36 + TableauPoints[BouclePoints, BoucleCourbes].X - 1,
                       53 + TableauPoints[BouclePoints, BoucleCourbes].Y + 1,
                       36 + TableauPoints[BouclePoints, BoucleCourbes].X + 1);
      END; {IF}
    END; {FOR}
  END; {FOR}
end;

end.
