UNIT Ugenerat;
{-----------------------------------------------------------------------------
  NOM DE L'UNITE : UGENERAT.PAS
  BUT            : Gnrateur de frquence.
  AUTEUR         : Michael Amarantidis / Stphane Claus
  DATE           : Fvrier, Mars 1997

  MODIFIE LE     : 12.04.1997  -  EDT:01
  RAISON         : - Ajout de commentaires
                   - Affiche les infos lors du changement de la frquence en
                     la saisissant dans la zone de texte

  MODIFIE LE     : 23.04.1997  -  EDT:02
  RAISON         : N'affiche pas le facteur de division lors de la saisie d'une
                   nouvelle frquence au clavier, car sinon la frquence que
                   l'on frappe est automatiquement crase par une frquence
                   calcule en fonction du facteur

  MODIFIE LE     : 22.05.1997  -  EDT:03
  RAISON         : - Affiche  nouveau le facteur de division lors de la saisie
                     d'une nouvelle frquence au clavier. Mais dans la fonction
                     aedtFacteurChange n'affiche pas le frquence voulue (c'est
                     pas une frquence qu'on cherche dans ce cas l, mais un
                     certain facteur de division)
                   - Limite  5 caractres de long le champ du facteur de
                     division (aedtFacteur)

  MODIFIE LE     :
  RAISON         :

  REMARQUES      : - Une fois le gnrateur lanc, il n'est plus possible de
                     l'arrter !
 -----------------------------------------------------------------------------}


{=============================================================================}
INTERFACE   {============================================== I N T E R F A C E }
{=============================================================================}



USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DigDisp, StdCtrls, Buttons, Vcl8254, Spin, ExtCtrls,
  UAlnEdit;


TYPE
  TfrmGenerateur = CLASS(TForm)
    digdspTitre: TDigitalDisplay;
    bitbtnOK: TBitBtn;
    bitbtnAide: TBitBtn;
    grpbcFacteurDivision: TGroupBox;
    spnbtnFacteur1: TSpinButton;
    rgrpCompteur: TRadioGroup;
    lblFact1: TLabel;
    lblFact10: TLabel;
    lblFact100: TLabel;
    lblFact1000: TLabel;
    spnbtnFacteur10: TSpinButton;
    spnbtnFacteur100: TSpinButton;
    spnbtnFacteur1000: TSpinButton;
    spnbtnFacteur10000: TSpinButton;
    lblFact10000: TLabel;
    grpbxFrequence: TGroupBox;
    lblFreqReelle: TLabel;
    lblFreqDesiree: TLabel;
    spnbtnChangeFreq: TSpinButton;
    lblHz1: TLabel;
    lblHz2: TLabel;
    aedtFreqVoulue: TAlignEdit;
    aedtFreqReelle: TAlignEdit;
    grpbxQuartz: TGroupBox;
    lblQuartz: TLabel;
    aedtFacteur: TAlignEdit;
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE spnbtnFacteurDownClick(Sender: TObject);
    PROCEDURE rgrpCompteurClick(Sender: TObject);
    PROCEDURE spnbtnFacteurUpClick(Sender: TObject);
    PROCEDURE aedtFreqVoulueChange(Sender: TObject);
    PROCEDURE aedtFacteurChange(Sender: TObject);
  PRIVATE
    { Private-dclarations }
  PUBLIC
    { Public-dclarations }
  END; {CLASS}


VAR
  frmGenerateur: TfrmGenerateur;



{=============================================================================}
IMPLEMENTATION   {================================= I M P L E M E N A T I O N }
{=============================================================================}



{$R *.DFM}


USES
  UPrincpl;


VAR
  NoCompteurChoisi : SHORTINT;


PROCEDURE TfrmGenerateur.FormActivate(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Initialisation de la fiche en fonction des paramtres
                    actuels du programme
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : --
 -----------------------------------------------------------------------------}
VAR
  Facteur : WORD;
BEGIN
  Caption := Application.Title;                          { Affichage du titre }
  IF debugmode THEN Color := debugcolor               { Couleur de la fentre }
               ELSE Color := clBtnFace;
  grpbcFacteurDivision.ShowHint := affichehint;
  spnbtnFacteur10000.ShowHint := affichehint;          { Affichage des Hint ? }
  spnbtnFacteur1000.ShowHint := affichehint;
  spnbtnFacteur100.ShowHint := affichehint;
  spnbtnFacteur10.ShowHint := affichehint;
  spnbtnFacteur1.ShowHint := affichehint;
  spnbtnChangeFreq.ShowHint := affichehint;
  rgrpCompteur.ShowHint := affichehint;
  aedtFacteur.ShowHint := affichehint;
  aedtFreqVoulue.ShowHint := affichehint;
  aedtFacteur.ShowHint := affichehint;
  CASE rgrpCompteur.ItemIndex OF                 { Rafrachissement des infos }
    0 : BEGIN
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur0 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur0;
        END; {BRANCH OF CASE}
    1 : BEGIN
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur1 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur1;
        END; {BRANCH OF CASE}
    2 : BEGIN
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur2 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur2;
        END; {BRANCH OF CASE}
    ELSE Facteur := 2;
  END; {CASE OF}
  IF Facteur > 0 THEN BEGIN                               { Affiche les infos }
    aedtFacteur.Text := IntToStr(Facteur);
    aedtFreqVoulue.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
    aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  END {IF}
  ELSE BEGIN
    aedtFacteur.Text := '';
    aedtFreqVoulue.Text := '';
    aedtFreqReelle.Text := '';
  END; {ELSE}
  lblQuartz.Caption := FloatToStr(frmMain.PIT8254.Quartz) + '[Hz]';  { Quartz }
END; {PROCEDURE FormActivate}


PROCEDURE TfrmGenerateur.spnbtnFacteurDownClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Diminue le facteur de division => Augmente la frquence
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Cette procdure est appele par tous les SpinBoutons
 -----------------------------------------------------------------------------}
VAR
  Facteur : LONGINT;
BEGIN
  CASE NoCompteurChoisi OF           { Valeur actuelle du facteur de division }
    0 : Facteur := FrmMain.PIT8254.Compteur0;
    1 : Facteur := FrmMain.PIT8254.Compteur1;
    2 : Facteur := FrmMain.PIT8254.Compteur2;
  END;
  Dec(Facteur, Abs((Sender AS TSpinButton).Tag));     { Diminution du facteur }
  IF Facteur < 2 THEN Facteur := 2;
  IF NOT debugmode THEN BEGIN
    CASE NoCompteurChoisi OF                       { Ecrit le nouveau facteur }
      0 : FrmMain.PIT8254.Compteur0 := Facteur;
      1 : FrmMain.PIT8254.Compteur1 := Facteur;
      2 : FrmMain.PIT8254.Compteur2 := Facteur;
    END; {CASE OF}
  END; {IF}
  aedtFacteur.Text := IntToStr(Facteur);                { Affichage des infos }
  aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  IF (Sender AS TSpinButton).Tag < 0 THEN BEGIN
    aedtFreqVoulue.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  END; {IF}
END; {PROCEDURE spnbtnFacteurDownClick}


PROCEDURE TfrmGenerateur.spnbtnFacteurUpClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Augmente le facteur de division => Diminue la frquence
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Cette procdure est appele par tous les SpinBoutons
 -----------------------------------------------------------------------------}
VAR
  Facteur : LONGINT;
BEGIN
  CASE NoCompteurChoisi OF           { Valeur actuelle du facteur de division }
    0 : Facteur := FrmMain.PIT8254.Compteur0;
    1 : Facteur := FrmMain.PIT8254.Compteur1;
    2 : Facteur := FrmMain.PIT8254.Compteur2;
  END;
  Inc(Facteur, Abs((Sender AS TSpinButton).Tag));   { Augmentation du facteur }
  IF Facteur > 65535 THEN Facteur := 65535;
  IF NOT debugmode THEN BEGIN
    CASE NoCompteurChoisi OF                       { Ecrit le nouveau facteur }
      0 : FrmMain.PIT8254.Compteur0 := Facteur;
      1 : FrmMain.PIT8254.Compteur1 := Facteur;
      2 : FrmMain.PIT8254.Compteur2 := Facteur;
    END; {CASE OF}
  END; {IF}
  aedtFacteur.Text := IntToStr(Facteur);                { Affichage des infos }
  aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  IF (Sender AS TSpinButton).Tag < 0 THEN BEGIN
    aedtFreqVoulue.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  END; {IF}
END; {PROCEDURE spnbtnFacteurUpClick}


PROCEDURE TfrmGenerateur.rgrpCompteurClick(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Choix d'un compteur
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le choix d'un compteur configurera ce dernier en mode
                    gnrateur
 -----------------------------------------------------------------------------}
VAR
  Facteur : WORD;
BEGIN
  NoCompteurChoisi := rgrpCompteur.ItemIndex;             { Choix du compteur }
  CASE NoCompteurChoisi OF
    0 : BEGIN                                      { Configuration compteur 0 }
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur0 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur0;
        END; {BRANCH OF CASE}
    1 : BEGIN                                      { Configuration compteur 1 }
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur1 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur1;
        END; {BRANCH OF CASE}
    2 : BEGIN                                      { Configuration compteur 2 }
          IF NOT debugmode THEN FrmMain.PIT8254.ModeCompteur2 := mcGenerateur;
          Facteur := frmMain.PIT8254.Compteur2;
        END; {BRANCH OF CASE}
  END; {CASE OF}
  IF Facteur > 0 THEN BEGIN                               { Affiche les infos }
    aedtFacteur.Text := IntToStr(Facteur);
    aedtFreqVoulue.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
    aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
  END {IF}
  ELSE BEGIN
    aedtFacteur.Text := '';
    aedtFreqVoulue.Text := '';
    aedtFreqReelle.Text := '';
  END; {ELSE}
  grpbcFacteurDivision.Enabled := TRUE;         { Active les autres contrles }
  grpbxFrequence.Enabled := TRUE;
END; {PROCEDURE rgrpCompteurClick}


PROCEDURE TfrmGenerateur.aedtFreqVoulueChange(Sender: TObject);
{-----------------------------------------------------------------------------
  BUT ........... : Change de frquence, en prenant celle que l'utilisateur
                    dsire
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le bloc try...except
                    Un bloc qui gre des exceptions est un bloc try..except.
                    Dans la partie try du bloc, les instructions s'excutent
                    dans l'ordre normal, sauf s'il se produit une exception;
                    dans ce cas, l'excution passe directement  la partie
                    except. Si aucune exception ne se produit, le bloc se
                    termine sans utiliser la partie except.
                    La partie except est une liste d'exceptions spcifiques et
                    des rponses qui y sont faites, chacune d'elles tant une
                    instruction on..do. Si aucune des instructions on..do ne
                    s'applique  l'exception active, c'est le gestionnaire
                    d'exception par dfaut de la partie else qui s'excute.
                    Lorsqu'un gestionnaire (spcifique ou par dfaut) gre
                    l'exception, le bloc se termine.
                    L'excution ne reprend pas dans le bloc  la suite d'une
                    exception.
 -----------------------------------------------------------------------------}
VAR
  Frequence  : EXTENDED;                                 { Nouvelle frquence }
  FacteurSup : LONGINT;                                     { Pour les calculs}
  FacteurInf : LONGINT;
  Facteur    : LONGINT;                         { Nouveau facteur de division }
  FreqSup    : REAL;                                        { Pour les calculs}
  FreqInf    : REAL;
BEGIN
  TRY
    { On voit rouge ! }
    aedtFreqVoulue.Color := clRed;
    {-- Lit la frquence saisie }
    Frequence := StrToFloat(aedtFreqVoulue.Text);
    {-- Hors limite ? }
    IF Frequence > (frmMain.PIT8254.Quartz / 2) THEN BEGIN
      Frequence := frmMain.PIT8254.Quartz / 2;
    END; {IF}
    IF Frequence < (frmMain.PIT8254.Quartz / 65535) THEN BEGIN
      Frequence := frmMain.PIT8254.Quartz / 65535;
    END; {IF}
    {-- Cherche le facteur de division le plus proche }
    FacteurSup   := Round(frmMain.PIT8254.Quartz / Frequence);
    FacteurInf   := Trunc(Int(frmMain.PIT8254.Quartz / Frequence));
    {-- Calcule les frquence avec les facteurs trouvs prcedemment }
    FreqSup := frmMain.PIT8254.Quartz / FacteurInf;
    FreqInf := frmMain.PIT8254.Quartz / FacteurSup;
    {-- Recherche le facteur de division qui nous permet d'tre le plus proche
        de la frquence voulue }
    IF ((Frequence = FreqSup) OR
       ((FreqSup - Frequence) < (Frequence - FreqInf))) THEN BEGIN
      Facteur := FacteurInf;
    END {IF}
    ELSE IF ((Frequence = FreqInf) OR
            ((FreqSup - Frequence) > (Frequence - FreqInf))) THEN BEGIN
      Facteur := FacteurSup;
    END; {ELSE IF}
    {-- Est-ce que les facteurs trouvs sont acceptables ?}
    IF Facteur < 2 THEN Facteur := 2;
    IF Facteur > 65535 THEN Facteur := 65535;
    {-- Change la frquence }
    IF NOT debugmode THEN BEGIN
      CASE NoCompteurChoisi OF
        0 : FrmMain.PIT8254.Compteur0 := Facteur;
        1 : FrmMain.PIT8254.Compteur1 := Facteur;
        2 : FrmMain.PIT8254.Compteur2 := Facteur;
      END; {CASE OF}
    END; {IF}
    {-- Affiche les infos }
    {EDT:02 N'affiche pas le facteur => n'appelle pas aedtFacteurChange car
            sinon, on se met en boucle et il est impossible de changer la
            frquence }
    {EDT:03 Affiche le facteur, mais dans la fonction aedtFacteurChange ne
            change pas la frquence voulue }
    aedtFacteur.Text := IntToStr(Facteur);
    aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
    {-- Couleur standard }
    aedtFreqVoulue.Color := clWindow;
  EXCEPT
    {-- Valeur incorrecte }
    aedtFreqVoulue.Color := clRed;                          { On voit rouge ! }
  END; {TRY}
END; {PROCEDURE aedtFreqVoulueChange}


PROCEDURE TfrmGenerateur.aedtFacteurChange(Sender: TObject);
{ BUT: Change de facteur de division en saisissant simplement le facteur }
{-----------------------------------------------------------------------------
  BUT ........... :
  ENTREE ........ : --
  SORTIE ........ : --
  EFFETS DE BORDS : --
  REMARQUE(S) ... : Le bloc try...except
                    Un bloc qui gre des exceptions est un bloc try..except.
                    Dans la partie try du bloc, les instructions s'excutent
                    dans l'ordre normal, sauf s'il se produit une exception;
                    dans ce cas, l'excution passe directement  la partie
                    except. Si aucune exception ne se produit, le bloc se
                    termine sans utiliser la partie except.
                    La partie except est une liste d'exceptions spcifiques et
                    des rponses qui y sont faites, chacune d'elles tant une
                    instruction on..do. Si aucune des instructions on..do ne
                    s'applique  l'exception active, c'est le gestionnaire
                    d'exception par dfaut de la partie else qui s'excute.
                    Lorsqu'un gestionnaire (spcifique ou par dfaut) gre
                    l'exception, le bloc se termine.
                    L'excution ne reprend pas dans le bloc  la suite d'une
                    exception.
 -----------------------------------------------------------------------------}
VAR
  Facteur : LONGINT;
BEGIN
  TRY
    aedtFacteur.Color := clRed;                    { Kamarad Soviet, It's Red }
    {-- Conversion du facteur saisi en un nombre }
    Facteur := StrToInt(aedtFacteur.Text);
    IF ((Facteur >= 2) AND (Facteur <= 65535)) THEN BEGIN
      {-- Plage du facteur correct }
      aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
      IF NOT debugmode THEN BEGIN
        {-- Change la frquence }
        CASE NoCompteurChoisi OF
          0 : FrmMain.PIT8254.Compteur0 := Facteur;
          1 : FrmMain.PIT8254.Compteur1 := Facteur;
          2 : FrmMain.PIT8254.Compteur2 := Facteur;
        END; {CASE OF}
      END; {IF}
      {EDT:01  Affiche les infos }
      {EDT:03  N'affiche pas la frquence voulue, car on se met en boucle... }
      {aedtFreqVoulue.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);}
      aedtFreqReelle.Text := FloatToStr(frmMain.PIT8254.Quartz / Facteur);
      aedtFacteur.Color := clWindow;                       { Couleur standard }
    END; {IF}
  EXCEPT
    aedtFacteur.Color := clRed;                             { It's ALWAYS Red }
  END; {TRY}
END; {PROCEDURE aedtFacteurChange}



{=============================================================================}
{ INITIALISATIONS ------------------------------------------- Initialisations }
{=============================================================================}



INITIALIZATION
END. {UNIT Ugenerat}
