unit longname;
{Functions to use long filenames}
{All functions start with "W32" to distinguish them from 16 bit functions}
{To call a function, use it like a normal function, with one exception:
 the last parameter must be the id value for that function. Example:
 longhandle:=W32FindFirstFile('c:\*.*',finddata,id_W32FindFirstFile);}

{VERY IMPORTANT: All these functions work fine on Windows 95, but NOT all work on
 Windows NT:
 - W32SetCurrentDirectory returns true, but does NOT actually change the current directory

 all other functions seem to work fine, but test your application on NT before saying that
 it runs fine!
}

interface

uses call32nt;

type
  longfile=longint;

{WIN32_FIND_DATA structure:}
type
  WIN32_FIND_DATA=record
    dwFileAttributes:longint;
    ftCreationTime,
    ftLastAccessTime,
    ftLastWriteTime:array[0..1] of longint;
    nFileSizeHigh,
    nFileSizeLow,
    dwReserved0,
    dwReserved1:longint;
    cFileName:array[0..259] of char;
    cAlternateFileName:array[0..13] of char;
  end;
  pWIN32_FIND_DATA=^WIN32_FIND_DATA;

type
  tFILETIME=record
    dwLowDateTime,
    dwHighDateTime:longint;
  end;
  pFILETIME=^tFILETIME;

  tSYSTEMTIME=record
    Year,
    Month,
    DayOfWeek,
    Day,
    Hour,
    Min,
    Sec,
    Milliseconds:word;
  end;

  tStartupInfo=record
    cb:longint;
    lpReserved,
    lpDesktop,
    lpTitle:pchar;
    dwX,
    dwY,
    dwXSize,
    dwYSize,
    dwXCountChars,
    dwYCountChars,
    dwFillAttribute,
    dwFlags:longint;
    wShowWindow,
    cbReserved2:word;
    lpReserved2:^byte;
    hStdInput,
    hStdOutput,
    hStdError:longint;
  end;

  PROCESS_INFORMATION=record
    hProcess,
    hThread,
    dwProcessId,
    dwThreadId:longint;
  end;

var
  W32FindFirstFile:function(lpszSearchFile:pchar;var lpffd:WIN32_FIND_DATA;id:longint):longint;
  W32FindNextFile:function(hFindFile:longint;var lpffd:WIN32_FIND_DATA;id:longint):longbool;
  W32FindClose:function(hFindFile:longint;id:longint):Longbool;
  W32FileTimeToSystemTime:function(var lpft:tFILETIME;var lpst:tsystemtime;id:longint):longbool;
  W32FileTimeToLocalFileTime:function(var lpft,lpftlocal:tFILETIME;id:longint):longbool;
  W32SystemTimeToFileTime:function(var lpst:tsystemtime;var lpft:tFILETIME;id:longint):longbool;
  W32LocalFileTimeToFileTime:function(var lpftlocal,lpft:tFILETIME;id:longint):longbool;
  W32GetCurrentDirectory:function(cchCurDir:longint;lpszCurDir:pchar;id:longint):longint;
  W32SetCurrentDirectory:function(lpszCurDir:pchar;id:longint):longbool;
  W32CreateFile:function(lpszName:pchar;fdwAccess,fdwShareMode:longint;lpsa:pointer;
                         fdwCreate,fdwAttrsAndFlags,hTemplateFile,id:longint):longint;
  W32MoveFile:function(lpszExisting,lpszNew:pchar;id:longint):longbool;
  W32GetLastError:function(id:longint):longint;
  W32CreateDirectory:function(path:pchar;security:pointer;id:longint):longbool;
  W32RemoveDirectory:function(path:pchar;id:longint):longbool;
  W32SetFileAttributes:function(path:pchar;attr,id:longint):longbool;
  W32GetFileAttributes:function(path:pchar;id:longint):longint;
  W32Deletefile:function(path:pchar;id:longint):longbool;
  W32SetFilePointer:function(hFile,lDistanceToMove:longint;lpDistanceToMoveHigh:pointer;
            dwMoveMethod,id:longint):longint;
  W32SetFileTime:function(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime;
            id:longint):longbool;
  W32GetFileTime:function(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime;
            id:longint):longbool;
  W32CloseHandle:function(hfile,id:longint):longbool;
  W32ReadFile:function(hFile:longint;var lpBuffer;nNumberOfBytesToRead:longint;
    var lpNumberOfBytesRead:longint;lpOverlapped:pointer;id:longint):longbool;
  W32WriteFile:function(hFile:longint;var lpBuffer;nNumberOfBytesToWrite:longint;
    var lpNumberOfBytesWritten:longint;lpOverlapped:pointer;id:longint):longbool;
  W32FlushFileBuffers:function(hfile,id:longint):longbool;
  W32ShellExecute:function(hwnd:longint;lpszOp,lpszFile,lpszParams,lpszDir:pchar;wShowCmd,id:longint):longint;
  W32WaitForSingleObject:function(hObject,dwTimeout,id:longint):longint;
  W32CreateProcess:function(lpszImageName,lpszCommandLine:pchar;lpsaProcess,lpsaThread:pointer;
    fInheritHandles:longbool;fdwCreate:longint;lpvEnvironment:pointer;lpszCurDir:pchar;var lpsiStartInfo:tstartupinfo;
    var lppiProcInfo:PROCESS_INFORMATION;id:longint):longbool;

var
  id_W32FindFirstFile,
  id_W32FindNextFile,
  id_W32FindClose,
  id_W32FileTimeToSystemTime,
  id_W32FileTimeToLocalFileTime,
  id_W32SystemTimeToFileTime,
  id_W32LocalFileTimeToFileTime,
  id_W32GetCurrentDirectory,
  id_W32SetCurrentDirectory,
  id_W32CreateFile,
  id_W32MoveFile,
  id_W32GetLastError,
  id_W32CreateDirectory,
  id_W32RemoveDirectory,
  id_W32SetFileAttributes,
  id_W32GetFileAttributes,
  id_W32Deletefile,
  id_W32SetFilePointer,
  id_W32setFileTime,
  id_W32GetFileTime,
  id_W32CloseHandle,
  id_W32ReadFile,
  id_W32WriteFile,
  id_W32FlushFileBuffers,
  id_W32ShellExecute,
  id_W32WaitForSingleObject,
  id_W32CreateProcess:longint;

implementation

begin
  @W32FindFirstFile:=@Call32;
  @W32FindNextFile:=@Call32;
  @W32FindClose:=@Call32;
  @W32FileTimeToSystemTime:=@Call32;
  @W32FileTimeToLocalFileTime:=@Call32;
  @W32SystemTimeToFileTime:=@Call32;
  @W32LocalFileTimeToFileTime:=@Call32;
  @W32GetCurrentDirectory:=@Call32;
  @W32SetCurrentDirectory:=@Call32;
  @W32CreateFile:=@Call32;
  @W32MoveFile:=@Call32;
  @W32GetLastError:=@Call32;
  @W32CreateDirectory:=@Call32;
  @W32RemoveDirectory:=@Call32;
  @W32SetFileAttributes:=@Call32;
  @W32GetFileAttributes:=@Call32;
  @W32Deletefile:=@Call32;
  @W32SetFilePointer:=@Call32;
  @W32setFileTime:=@Call32;
  @W32GetFileTime:=@Call32;
  @W32CloseHandle:=@Call32;
  @W32ReadFile:=@Call32;
  @W32WriteFile:=@Call32;
  @W32FlushFileBuffers:=@Call32;
  @W32ShellExecute:=@Call32;
  @W32WaitForSingleObject:=@Call32;
  @W32CreateProcess:=@Call32;

  id_W32FindFirstFile:=Declare32('FindFirstFile', 'kernel32', 'pp');
  id_W32FindNextFile:=Declare32('FindNextFile', 'kernel32', 'ip');
  id_W32FindClose:=Declare32('FindClose', 'kernel32', 'i');
  id_W32FileTimeToSystemTime:=Declare32('FileTimeToSystemTime', 'kernel32', 'pp');
  id_W32FileTimeToLocalFileTime:=Declare32('FileTimeToLocalFileTime', 'kernel32', 'pp');
  id_W32SystemTimeToFileTime:=Declare32('SystemTimeToFileTime','kernel32','pp');
  id_W32LocalFileTimeToFileTime:=Declare32('LocalFileTimeToFileTime','kernel32','pp');
  id_W32GetCurrentDirectory:=Declare32('GetCurrentDirectory','kernel32','ip');
  id_W32SetCurrentDirectory:=Declare32('SetCurrentDirectory','kernel32','p');
  id_W32CreateFile:=Declare32('CreateFile','kernel32','piipiii');
  id_W32MoveFile:=Declare32('MoveFile','kernel32','pp');
  id_W32GetLastError:=Declare32('GetLastError','kernel32','');
  id_W32CreateDirectory:=Declare32('CreateDirectory','kernel32','pp');
  id_W32RemoveDirectory:=Declare32('RemoveDirectory','kernel32','p');
  id_W32SetFileAttributes:=Declare32('SetFileAttributes','kernel32','pi');
  id_W32GetFileAttributes:=Declare32('GetFileAttributes','kernel32','p');
  id_W32Deletefile:=Declare32('DeleteFile','kernel32','p');
  id_W32SetFilePointer:=Declare32('SetFilePointer','kernel32','iipi');
  id_W32setFileTime:=Declare32('SetFileTime','kernel32','ippp');
  id_W32GetFileTime:=Declare32('GetFileTime','kernel32','ippp');
  id_W32CloseHandle:=Declare32('CloseHandle','kernel32','i');
  id_W32ReadFile:=Declare32('ReadFile','kernel32','ipipp');
  id_W32WriteFile:=Declare32('WriteFile','kernel32','ipipp');
  id_W32FlushFileBuffers:=Declare32('FlushFileBuffers','kernel32','i');
  id_W32ShellExecute:=Declare32('ShellExecute','shell32','wppppi');
  id_W32WaitForSingleObject:=Declare32('WaitForSingleObject','kernel32','ii');
  id_W32CreateProcess:=Declare32('CreateProcess','kernel32','ppppiipppp');
end.
